/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;

public class LimitedOutputStream
extends OutputStream {
    private final AtomicLong counter = new AtomicLong(0L);
    private final long limit;
    private final OutputStream outputStream;

    public LimitedOutputStream(OutputStream outputStream, long limit) {
        this.outputStream = outputStream;
        this.limit = limit;
    }

    @Override
    public void write(int b) throws IOException {
        this.counter.getAndIncrement();
        if (this.counter.get() > this.limit) {
            throw new IOException("Max limit exceeded");
        }
        this.outputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

