/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import jakarta.inject.Inject;
import jakarta.websocket.server.ServerEndpointConfig;

public class GuiceEndpointFactory
extends ServerEndpointConfig.Configurator {
    private final Injector injector;

    @Inject
    public GuiceEndpointFactory(Injector injector) {
        this.injector = injector;
    }

    public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
        try {
            return (T)this.injector.getInstance(endpointClass);
        }
        catch (ConfigurationException | ProvisionException e) {
            throw new InstantiationException(String.format("%s: %s", e.getClass().getName(), e.getMessage()));
        }
    }
}

