/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import de.ponton.securelistener.administration.CommandTask;
import de.ponton.securelistener.security.RandomGenerator;
import de.ponton.securelistener.websocket.AbstractEndpoint;
import de.ponton.securelistener.websocket.ClientWebsocketAuthorization;
import de.ponton.securelistener.websocket.CommandExecutor;
import de.ponton.securelistener.websocket.SessionPoolManager;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigEndpoint
extends AbstractEndpoint {
    public static final String NAME = "Config";
    private static final Logger LOG = LoggerFactory.getLogger((String)"Listener.ConfigEndpoint");
    private static final int INIT_SIZE = 1024;
    private ByteArrayOutputStream data = new ByteArrayOutputStream(1024);
    private Map<String, String> headers = new HashMap<String, String>();
    private final CommandExecutor executor;

    @Inject
    public ConfigEndpoint(SessionPoolManager sessionPoolManager, CommandExecutor executor, RandomGenerator generator, ClientWebsocketAuthorization authorization) {
        super(sessionPoolManager.getSessionPool(NAME), generator, authorization);
        this.executor = executor;
    }

    public void onMessage(String message) {
        LOG.debug("receiving Request Headers");
        BufferedReader reader = new BufferedReader(new StringReader(message));
        String headerLine = null;
        try {
            while ((headerLine = reader.readLine()) != null) {
                String[] header = headerLine.split(": ");
                if (header.length <= 1) continue;
                this.headers.put(header[0], header[1]);
            }
        }
        catch (IOException e) {
            LOG.error("error while receiving request headers: {}", (Object)e.toString());
        }
    }

    public void onMessage(byte[] partialMessage, boolean last) {
        if (!this.authenticated) {
            this.handleChallengeResponse(partialMessage);
        } else if (last) {
            LOG.debug("receiving Request Data complete trigger");
            this.executor.execute(new CommandTask(this.headers, this.data.toByteArray(), this.session));
            this.data = new ByteArrayOutputStream(1024);
            this.headers = new HashMap<String, String>();
        } else {
            LOG.debug("receiving Request Data {} bytes", (Object)partialMessage.length);
            try {
                this.data.write(partialMessage);
            }
            catch (IOException e) {
                LOG.error("error while receiving request data: {}", (Object)e.toString());
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

