/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import de.ponton.securelistener.config.ListenerProperties;
import de.ponton.securelistener.websocket.AuthorizationException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class ClientWebsocketAuthorization {
    private static final Logger LOG = LogManager.getLogger((String)"Listener.ClientWebsocketAuthorization");
    private final File storage;
    private Properties certificateStorage;
    private boolean automaticallyAcceptFirstClient;
    private boolean ignoreIdExchange;

    @Inject
    public ClientWebsocketAuthorization(ListenerProperties config) throws IOException {
        this.storage = new File(config.getInternalCommunicationAuthorizationStore());
        this.automaticallyAcceptFirstClient = config.isAutomaticallyAcceptingFirstClient();
        this.ignoreIdExchange = config.isIgnoreIdExchange();
        this.readStorage(this.storage);
    }

    private void readStorage(File storage) throws IOException {
        this.certificateStorage = new Properties();
        try (FileReader reader = new FileReader(storage);){
            this.certificateStorage.load(reader);
        }
        catch (FileNotFoundException e) {
            LOG.warn("certificate store not found. creating a new one at " + storage.getAbsolutePath());
        }
    }

    private void storeStorage() throws IOException {
        try (FileWriter writer = new FileWriter(this.storage);){
            this.certificateStorage.store(writer, "authorized Messenger instance ID = true/false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyClientCertificate(X509Certificate cer) throws AuthorizationException {
        if (this.ignoreIdExchange) {
            LOG.info("Ignoring Messenger Id Exchange");
            return;
        }
        String keyHash = this.createLookupKey(cer);
        ClientWebsocketAuthorization clientWebsocketAuthorization = this;
        synchronized (clientWebsocketAuthorization) {
            if (this.certificateStorage.isEmpty() && this.automaticallyAcceptFirstClient) {
                try {
                    LOG.info("automatically accepted first connection");
                    this.addAcceptedCertificate(cer);
                }
                catch (IOException e) {
                    LOG.warn("could not store first received certificate: " + e.toString());
                }
            }
        }
        String isAuthorized = this.certificateStorage.getProperty(keyHash, "false");
        if (!isAuthorized.equals("true")) {
            throw new AuthorizationException("unauthorized Messenger instance: " + keyHash);
        }
        LOG.info("authorized Messenger instance: {}", (Object)keyHash);
    }

    private String createLookupKey(X509Certificate cer) {
        byte[] publicKey = cer.getPublicKey().getEncoded();
        byte[] keyhash = this.digestPublicKey(publicKey);
        return Base64.getUrlEncoder().encodeToString(keyhash).substring(0, 16);
    }

    public synchronized void addAcceptedCertificate(X509Certificate cert) throws IOException {
        String keyHash = this.createLookupKey(cert);
        this.certificateStorage.setProperty(keyHash, "true");
        this.storeStorage();
    }

    private byte[] digestPublicKey(byte[] publicKey) {
        try {
            MessageDigest crc = MessageDigest.getInstance("SHA-256");
            crc.update(publicKey);
            byte[] keyhash = crc.digest();
            return keyhash;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("could not digest public key", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

