/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.websocket;

import de.ponton.securelistener.security.RandomGenerator;
import de.ponton.securelistener.websocket.AuthorizationException;
import de.ponton.securelistener.websocket.ClientWebsocketAuthorization;
import de.ponton.securelistener.websocket.ConnectionLimitException;
import de.ponton.securelistener.websocket.SessionPool;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.StoreException;
import org.slf4j.Logger;

public abstract class AbstractEndpoint
extends Endpoint
implements MessageHandler.Whole<String>,
MessageHandler.Partial<byte[]> {
    protected Session session;
    protected final SessionPool sessionPool;
    private byte[] challenge;
    protected boolean authenticated;
    private final RandomGenerator randomGenerator;
    private final ClientWebsocketAuthorization authorization;

    protected abstract Logger getLogger();

    public AbstractEndpoint(SessionPool sessionPool, RandomGenerator random, ClientWebsocketAuthorization authorization) {
        this.sessionPool = sessionPool;
        this.randomGenerator = random;
        this.authorization = authorization;
        this.getLogger().trace("init Endpoint");
    }

    protected void sendChallenge() {
        try {
            this.challenge = new byte[16];
            this.randomGenerator.nextBytes(this.challenge);
            ByteBuffer buffer = ByteBuffer.wrap(this.challenge);
            this.session.getBasicRemote().sendBinary(buffer);
            this.getLogger().debug("sendChallenge done");
        }
        catch (IOException e) {
            this.getLogger().error("could not sendChallenge: {}", (Throwable)e);
        }
    }

    protected void handleChallengeResponse(byte[] partialMessage) {
        ByteArrayInputStream sigStream = new ByteArrayInputStream(partialMessage);
        ByteArrayInputStream dataStream = new ByteArrayInputStream(this.challenge);
        CMSTypedStream cmsDataStream = new CMSTypedStream((InputStream)dataStream);
        try {
            CMSSignedDataParser dataParser = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().build(), cmsDataStream, (InputStream)sigStream);
            dataParser.getSignedContent().drain();
            Store certStore = dataParser.getCertificates();
            SignerInformationStore signerInfos = dataParser.getSignerInfos();
            Collection signers = signerInfos.getSigners();
            Iterator it = signers.iterator();
            SignerInformation signer = (SignerInformation)it.next();
            SignerId id = signer.getSID();
            Collection certs = certStore.getMatches((Selector)id);
            X509CertificateHolder cert = (X509CertificateHolder)certs.iterator().next();
            this.authenticated = signer.verify(new JcaSimpleSignerInfoVerifierBuilder().build(cert));
            if (this.authenticated) {
                X509Certificate cer = this.getX509Certificate(cert);
                cer.verify(cer.getPublicKey());
                this.authorization.verifyClientCertificate(cer);
                this.sessionPool.addSession(this.session);
            } else {
                this.getLogger().error("signature of challenge response is invalid");
                this.closeSessionQuietly(CloseReason.CloseCodes.VIOLATED_POLICY, "Challenge response invalid");
            }
        }
        catch (CertificateException | CMSException | OperatorCreationException | StoreException e) {
            this.getLogger().error("signature validation failed: {}", (Object)e.toString());
            this.closeSessionQuietly(CloseReason.CloseCodes.VIOLATED_POLICY, "Challenge response invalid");
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            this.getLogger().error("client certificate validation failed: {}", (Object)e.toString());
            this.closeSessionQuietly(CloseReason.CloseCodes.VIOLATED_POLICY, "Messenger instance not authorized");
        }
        catch (AuthorizationException e) {
            this.getLogger().error(e.getMessage());
            this.closeSessionQuietly(CloseReason.CloseCodes.VIOLATED_POLICY, "Messenger instance not authorized");
        }
        catch (ConnectionLimitException e) {
            this.getLogger().error(e.getMessage());
            this.closeSessionQuietly(CloseReason.CloseCodes.VIOLATED_POLICY, "Listener connection limit exceeded");
        }
    }

    private void closeSessionQuietly(CloseReason.CloseCodes code, String comment) {
        try {
            this.session.close(new CloseReason((CloseReason.CloseCode)code, comment));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private X509Certificate getX509Certificate(X509CertificateHolder cert) throws IOException, CertificateException, NoSuchProviderException {
        byte[] certData = cert.getEncoded();
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream in = new ByteArrayInputStream(certData);
        X509Certificate cer = (X509Certificate)certFactory.generateCertificate(in);
        return cer;
    }

    public void onClose(Session session, CloseReason close) {
        this.session = null;
        String remoteHost = this.getRemoteHost(session);
        this.getLogger().info("WebSocket Close: sessionId:{}, using SSL:{}, remote:{}: {} - {}", new Object[]{session.getId(), session.isSecure(), remoteHost, close.getCloseCode(), close.getReasonPhrase()});
        this.sessionPool.removeSession(session);
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        String remoteHost = this.getRemoteHost(session);
        this.getLogger().info("WebSocket Connect: sessionId:{}, using SSL:{}, remote:{}", new Object[]{session.getId(), session.isSecure(), remoteHost});
        session.addMessageHandler((MessageHandler)this);
        this.sendChallenge();
    }

    public void onError(Session session, Throwable cause) {
        this.session = session;
        String remoteHost = this.getRemoteHost(session);
        if (cause.getCause() != null) {
            this.getLogger().error("WebSocket Error: session: {}, remote:{} : {} {}", new Object[]{session, remoteHost, cause.toString(), cause.getCause().toString()});
        } else {
            this.getLogger().error("WebSocket Error: session: {}, remote:{} : {}", new Object[]{session, remoteHost, cause.toString()});
        }
    }

    private String getRemoteHost(Session session) {
        try {
            return session.getUserProperties().get("jakarta.websocket.endpoint.remoteAddress").toString();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }
}

