/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.proxy;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.ee10.proxy.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingProxyServlet
extends ProxyServlet {
    private static final Logger LOG = LoggerFactory.getLogger((String)"Proxy.ProxyServlet");

    public boolean validateDestination(String host, int port) {
        boolean valid = super.validateDestination(host, port);
        if (!valid) {
            LOG.error("destination {} is not in whitelist", (Object)host);
        }
        return valid;
    }

    protected HttpClient createHttpClient() throws ServletException {
        HttpClient client = super.createHttpClient();
        ServletConfig config = this.getServletConfig();
        String t = config.getInitParameter("connectTimeout");
        if (t != null) {
            client.setConnectTimeout((long)Integer.parseInt(t));
        }
        return client;
    }

    protected Logger createLogger() {
        return LOG;
    }
}

