/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.administration.certs;

import de.ponton.securelistener.SecureListener;
import de.ponton.securelistener.administration.certs.CertRequest;
import de.ponton.securelistener.security.CertificateUtils;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class GenerateCertificateRequest {
    private static final String ALGORITHM = "SHA1WithRSA";
    private StringBuilder _subject;
    private CertRequest _csr;
    private KeyPair _keyPair;
    private static final String IPV4_PATTERN = "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$";
    private static final String IPV6_PATTERN = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static final Pattern ipv6_pattern = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");
    private static final Pattern ipv4_pattern = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\\.(?!$)|$)){4}$");

    public GenerateCertificateRequest(CertRequest csr) throws Exception {
        this._csr = csr;
        this.generateRequest();
    }

    public CertRequest getCertRequest() {
        return this._csr;
    }

    private void generateRequest() throws Exception {
        int keysize = 1024;
        String keyPair = "RSA";
        if (this._csr.getKeyLength() != null && this._csr.getKeyLength().length() > 0) {
            keysize = Integer.parseInt(this._csr.getKeyLength());
        }
        if (this._csr.getKeyPair() != null && this._csr.getKeyPair().length() > 0) {
            keyPair = this._csr.getKeyPair();
        }
        this._keyPair = CertificateUtils.getInstance().generateKeyPair(keyPair, Integer.valueOf(keysize));
        this._subject = new StringBuilder();
        this._subject.append("CN=\"" + this._csr.getCn() + "\", ");
        if (this._csr.getOu() != null && this._csr.getOu().length() > 0) {
            this._subject.append("OU=\"" + this._csr.getOu() + "\", ");
        }
        this._subject.append("O=\"" + this._csr.getO() + "\", ");
        if (this._csr.getL() != null && this._csr.getL().length() > 0) {
            this._subject.append("L=\"" + this._csr.getL() + "\", ");
        }
        if (this._csr.getSt() != null && this._csr.getSt().length() > 0) {
            this._subject.append("ST=\"" + this._csr.getSt() + "\", ");
        }
        this._subject.append("C=\"" + this._csr.getC() + "\", ");
        this._subject.append("E=\"" + this._csr.getEmail() + "\"");
        X500Name name = new X500Name(this._subject.toString());
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(name, this._keyPair.getPublic());
        if (this._csr.getSan() != null && !this._csr.getSan().isBlank()) {
            this.createSanExtension(this._csr.getSan(), (PKCS10CertificationRequestBuilder)p10Builder);
        }
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(CertificateUtils.getInstance().getAlgorithm(this._keyPair.getPrivate()));
        ContentSigner signer = csBuilder.build(this._keyPair.getPrivate());
        PKCS10CertificationRequest certRequest = p10Builder.build(signer);
        this.storeRequest();
        this._csr.setRequest(CertificateUtils.certRequestBase64Encoded((PKCS10CertificationRequest)certRequest).getBytes());
    }

    private void createSanExtension(String san, PKCS10CertificationRequestBuilder p10Builder) {
        try {
            ExtensionsGenerator extGen = new ExtensionsGenerator();
            extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(Arrays.stream(san.split(",")).map(this::createGeneralName).collect(Collectors.toList()).toArray(new GeneralName[0])));
            p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private GeneralName createGeneralName(String value) {
        return ipv6_pattern.matcher(value).matches() || ipv4_pattern.matcher(value).matches() ? new GeneralName(7, value) : new GeneralName(2, value);
    }

    private void storeRequest() throws Exception {
        X509Certificate selfCert = CertificateUtils.createSelfSignedCertificate((String)this._subject.toString(), (PublicKey)this._keyPair.getPublic(), (PrivateKey)this._keyPair.getPrivate());
        SecureListener.getInstance().getTempServerKeystore().addTempPrivateKey("jetty", this._keyPair.getPrivate(), this._csr.getPassword().toCharArray(), selfCert);
    }
}

