/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSA13Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSASigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        BcTlsSigner signer;
        if (privateKey instanceof RSAKeyParameters) {
            int signatureScheme;
            RSAKeyParameters privKeyRSA = (RSAKeyParameters)privateKey;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsRSAPSSSigner(crypto, privKeyRSA, signatureScheme);
            }
            signer = new BcTlsRSASigner(crypto, privKeyRSA);
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            signer = new BcTlsDSASigner(crypto, (DSAPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            int signatureScheme;
            ECPrivateKeyParameters privKeyEC = (ECPrivateKeyParameters)privateKey;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new BcTlsECDSA13Signer(crypto, privKeyEC, signatureScheme);
            }
            signer = new BcTlsECDSASigner(crypto, privKeyEC);
        } else if (privateKey instanceof Ed25519PrivateKeyParameters) {
            signer = new BcTlsEd25519Signer(crypto, (Ed25519PrivateKeyParameters)privateKey);
        } else if (privateKey instanceof Ed448PrivateKeyParameters) {
            signer = new BcTlsEd448Signer(crypto, (Ed448PrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

