/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsKemConfig;
import org.bouncycastle.tls.crypto.TlsKemDomain;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKem;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsMLKemDomain
implements TlsKemDomain {
    protected final JcaTlsCrypto crypto;
    protected final MLKEMParameters kyberParameters;
    protected final boolean isServer;

    protected static MLKEMParameters getKyberParameters(int namedGroup) {
        switch (namedGroup) {
            case 583: {
                return MLKEMParameters.ml_kem_512;
            }
            case 584: 
            case 1896: {
                return MLKEMParameters.ml_kem_768;
            }
            case 585: 
            case 4132: {
                return MLKEMParameters.ml_kem_1024;
            }
        }
        return null;
    }

    public JceTlsMLKemDomain(JcaTlsCrypto crypto, TlsKemConfig kemConfig) {
        this.crypto = crypto;
        this.kyberParameters = JceTlsMLKemDomain.getKyberParameters(kemConfig.getNamedGroup());
        this.isServer = kemConfig.isServer();
    }

    public JceTlsSecret adoptLocalSecret(byte[] secret) {
        return this.crypto.adoptLocalSecret(secret);
    }

    @Override
    public TlsAgreement createKem() {
        return new JceTlsMLKem(this);
    }

    public JceTlsSecret decapsulate(MLKEMPrivateKeyParameters privateKey, byte[] ciphertext) {
        MLKEMExtractor kemExtract = new MLKEMExtractor(privateKey);
        byte[] secret = kemExtract.extractSecret(ciphertext);
        return this.adoptLocalSecret(secret);
    }

    public MLKEMPublicKeyParameters decodePublicKey(byte[] encoding) {
        return new MLKEMPublicKeyParameters(this.kyberParameters, encoding);
    }

    public SecretWithEncapsulation encapsulate(MLKEMPublicKeyParameters publicKey) {
        MLKEMGenerator kemGen = new MLKEMGenerator(this.crypto.getSecureRandom());
        return kemGen.generateEncapsulated((AsymmetricKeyParameter)publicKey);
    }

    public byte[] encodePublicKey(MLKEMPublicKeyParameters publicKey) {
        return publicKey.getEncoded();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        MLKEMKeyPairGenerator keyPairGenerator = new MLKEMKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)new MLKEMKeyGenerationParameters(this.crypto.getSecureRandom(), this.kyberParameters));
        return keyPairGenerator.generateKeyPair();
    }

    public boolean isServer() {
        return this.isServer;
    }
}

