/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class PolyVecMatrix {
    private final int dilithiumK;
    private final int dilithiumL;
    private final PolyVecL[] mat;

    public PolyVecMatrix(MLDSAEngine engine) {
        this.dilithiumK = engine.getDilithiumK();
        this.dilithiumL = engine.getDilithiumL();
        this.mat = new PolyVecL[this.dilithiumK];
        for (int i = 0; i < this.dilithiumK; ++i) {
            this.mat[i] = new PolyVecL(engine);
        }
    }

    public void pointwiseMontgomery(PolyVecK t, PolyVecL v) {
        for (int i = 0; i < this.dilithiumK; ++i) {
            t.getVectorIndex(i).pointwiseAccountMontgomery(this.mat[i], v);
        }
    }

    public void expandMatrix(byte[] rho) {
        for (int i = 0; i < this.dilithiumK; ++i) {
            for (int j = 0; j < this.dilithiumL; ++j) {
                this.mat[i].getVectorIndex(j).uniformBlocks(rho, (short)((i << 8) + j));
            }
        }
    }

    private String addString() {
        Object out = "[";
        for (int i = 0; i < this.dilithiumK; ++i) {
            out = (String)out + "Outer Matrix " + i + " [";
            out = (String)out + this.mat[i].toString();
            out = i == this.dilithiumK - 1 ? (String)out + "]\n" : (String)out + "],\n";
        }
        out = (String)out + "]\n";
        return out;
    }

    public String toString(String name) {
        return name.concat(": \n" + this.addString());
    }
}

