/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.mlkem;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KEMSpi;
import org.bouncycastle.jcajce.provider.asymmetric.mlkem.BCMLKEMPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.mlkem.BCMLKEMPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.mlkem.MLKEMDecapsulatorSpi;
import org.bouncycastle.jcajce.provider.asymmetric.mlkem.MLKEMEncapsulatorSpi;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;

public class MLKEMSpi
implements KEMSpi {
    @Override
    public KEMSpi.EncapsulatorSpi engineNewEncapsulator(PublicKey publicKey, AlgorithmParameterSpec spec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (!(publicKey instanceof BCMLKEMPublicKey)) {
            throw new InvalidKeyException("unsupported key");
        }
        if (spec == null) {
            spec = new KTSParameterSpec.Builder("Generic", 256).withNoKdf().build();
        }
        if (!(spec instanceof KTSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("MLKEM can only accept KTSParameterSpec");
        }
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
        }
        return new MLKEMEncapsulatorSpi((BCMLKEMPublicKey)publicKey, (KTSParameterSpec)spec, secureRandom);
    }

    @Override
    public KEMSpi.DecapsulatorSpi engineNewDecapsulator(PrivateKey privateKey, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (!(privateKey instanceof BCMLKEMPrivateKey)) {
            throw new InvalidKeyException("unsupported key");
        }
        if (spec == null) {
            spec = new KTSParameterSpec.Builder("Generic", 256).withNoKdf().build();
        }
        if (!(spec instanceof KTSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("MLKEM can only accept KTSParameterSpec");
        }
        return new MLKEMDecapsulatorSpi((BCMLKEMPrivateKey)privateKey, (KTSParameterSpec)spec);
    }
}

