/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.proxy;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.eclipse.jetty.util.Callback;

public class LoggingConnectHandler
extends ConnectHandler {
    private static final Logger _log = LogManager.getLogger((String)"Proxy.ConnectHandler");

    public LoggingConnectHandler() {
    }

    public LoggingConnectHandler(Handler handler) {
        super(handler);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (HttpMethod.CONNECT.is(request.getMethod())) {
            TunnelSupport tunnelSupport = request.getTunnelSupport();
            if (tunnelSupport == null) {
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)501);
                return true;
            }
            if (tunnelSupport.getProtocol() == null) {
                HttpURI httpURI = request.getHttpURI();
                String serverAddress = httpURI.getAuthority();
                _log.info("CONNECT request from {} for {}", (Object)request.getConnectionMetaData().getRemoteSocketAddress(), (Object)serverAddress);
                this.handleConnect(request, response, callback, serverAddress);
                return true;
            }
        }
        _log.info("{} request from {} for {}", (Object)request.getMethod(), (Object)request.getConnectionMetaData().getRemoteSocketAddress(), (Object)request.getHttpURI().asString());
        return super.handle(request, response, callback);
    }

    public boolean validateDestination(String host, int port) {
        boolean valid = super.validateDestination(host, port);
        if (!valid) {
            _log.error("destination {} is not in whitelist", (Object)host);
        }
        return valid;
    }
}

