/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.ftp;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.util.EncryptUtils;

public class SaltedPasswordEncryptor
implements PasswordEncryptor {
    private static final String HASH_ALG = "SHA-256";
    private final SecureRandom rnd = new SecureRandom();
    private static final int MAX_SEED = 99999999;
    private static final int HASH_ITERATIONS = 1000;

    private String encrypt(String password, String salt) {
        Object hash = salt + password;
        for (int i = 0; i < 1000; ++i) {
            try {
                hash = EncryptUtils.encrypt((String)hash, (String)HASH_ALG);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return salt + ":" + (String)hash;
    }

    private String legacyEncrypt(String password) {
        return EncryptUtils.encryptMD5((String)password);
    }

    public String encrypt(String password) {
        String seed = Integer.toString(this.rnd.nextInt(99999999));
        return this.encrypt(password, seed);
    }

    public boolean matches(String passwordToCheck, String storedPassword) {
        if (storedPassword == null) {
            throw new NullPointerException("storedPassword can not be null");
        }
        if (passwordToCheck == null) {
            throw new NullPointerException("passwordToCheck can not be null");
        }
        int divider = storedPassword.indexOf(58);
        if (divider < 1) {
            return this.legacyEncrypt(passwordToCheck).equalsIgnoreCase(storedPassword);
        }
        String storedSalt = storedPassword.substring(0, divider);
        return this.encrypt(passwordToCheck, storedSalt).equalsIgnoreCase(storedPassword);
    }
}

