<?xml version="1.0" encoding="ISO-8859-1"?>
<!--
   XML to HTML Verbatim Formatter with Syntax Highlighting
   HTML wrapper
   Version 1.1
   LGPL (c) Oliver Becker, 2002-11-04
   obecker@informatik.hu-berlin.de
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <xsl:import href="htmlOutput.xsl" />

   <xsl:output method="html"
               doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" />

   <!-- select the name of an element that should be formatted
        (print only these elements and their contents) -->
   <xsl:param name="select" />

   <!-- root -->
   <xsl:template match="/">
      <xsl:apply-templates select="/" mode="xmlverbwrapper" />
   </xsl:template>

   <xsl:template match="/" mode="xmlverbwrapper">
      <html>
         <head>
            <title>XML source view</title>
              <!-- CSS Stylesheet -->
	          <style type="text/css">
				.xmlverb-default          { color: #333333; background-color: #ffffff;
				                            font-family: monospace }
				.xmlverb-element-name     { color: #008080 }
				.xmlverb-element-nsprefix { color: #666600 }
				.xmlverb-attr-name        { color: #7f007f }
				.xmlverb-attr-content     { color: #2a00ff; font-weight: bold }
				.xmlverb-ns-name          { color: #666600 }
				.xmlverb-ns-uri           { color: #330099 }
				.xmlverb-text             { color: #000000; font-weight: bold }
				.xmlverb-comment          { color: #3f5fbf; font-style: italic }
				.xmlverb-pi-name          { color: #006600; font-style: italic }
				.xmlverb-pi-content       { color: #006666; font-style: italic }
              </style>
         </head>
         <body class="xmlverb-default">
            <h2>No Stylesheet defined for this message - default output format used</h2>
			<p>
			To install a stylesheet, please do the following:<BR/>
			1. ensure that a valid stylesheet exists in directory:
			   '...\config\XSL\...'<BR/>
			2. edit '...\config\Schemata\&lt;schemasetname&gt;.xml'<BR/>
			3. update the &lt;XSLFile&gt; entry for the stylesheet file.<BR/>
			</p>
			<hr/>
            <tt>
               <xsl:choose>
                  <!-- "select" parameter present? -->
                  <xsl:when test="$select">
                     <xsl:apply-templates mode="xmlverbwrapper" />
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:apply-templates select="." mode="xmlverb" />
                  </xsl:otherwise>
               </xsl:choose>
            </tt>
         </body>
      </html>
      <xsl:text>&#xA;</xsl:text>
   </xsl:template>

   <xsl:template match="*" mode="xmlverbwrapper">
      <xsl:choose>
         <xsl:when test="name()=$select">
            <!-- switch to render mode -->
            <!-- print indent -->
            <span class="xmlverb-text">
               <xsl:call-template name="preformatted-output">
                  <xsl:with-param name="text">
                     <xsl:call-template name="find-last-line">
                        <xsl:with-param name="text"
                              select="preceding-sibling::node()[1][self::text()]" />
                     </xsl:call-template>
                  </xsl:with-param>
               </xsl:call-template>
            </span>
            <!-- print element -->
            <xsl:apply-templates select="." mode="xmlverb" />
            <br /><br />
         </xsl:when>
         <xsl:otherwise>
            <!-- look for the selected element among the children -->
            <xsl:apply-templates select="*" mode="xmlverbwrapper" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!-- return the last line (after newline) in parameter $text -->
   <xsl:template name="find-last-line">
      <xsl:param name="text" />
      <xsl:choose>
         <xsl:when test="contains($text,'&#xA;')">
            <xsl:call-template name="find-last-line">
               <xsl:with-param name="text"
                    select="substring-after($text,'&#xA;')" />
            </xsl:call-template>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$text" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

</xsl:stylesheet>
