/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.security;

import de.ponton.securelistener.encoding.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import java.util.GregorianCalendar;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class CertificateUtils {
    public static final String REQUEST_HEADER = "-----BEGIN CERTIFICATE REQUEST-----\n";
    public static final String REQUEST_FOOTER = "\n-----END CERTIFICATE REQUEST-----\n";
    public static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----\n";
    public static final String CERT_FOOTER = "\n-----END CERTIFICATE-----\n";
    private static final String SHA_256_WITH_RSA = "SHA256WithRSA";
    private static final String SHA_256_WITH_ECDSA = "SHA256withECDSA";
    private static SecureRandom _random;
    private static CertificateUtils _cert;

    public static CertificateUtils getInstance() {
        if (_cert == null) {
            _cert = new CertificateUtils();
        }
        return _cert;
    }

    private CertificateUtils() {
        _random = new SecureRandom();
        _random.nextInt();
    }

    public final KeyPair generateKeyPair(String algorithm, Integer keySize) throws GeneralSecurityException {
        if (algorithm.equals("RSA")) {
            return this.generateRSAKeyPair(algorithm, keySize);
        }
        return this.generateECKeypair(algorithm);
    }

    public String getAlgorithm(PrivateKey privateKey) {
        if (privateKey instanceof ECPrivateKey) {
            return SHA_256_WITH_ECDSA;
        }
        if (privateKey instanceof RSAPrivateKey) {
            return SHA_256_WITH_RSA;
        }
        throw new IllegalArgumentException("Private Key type is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair generateRSAKeyPair(String algorithm, Integer keySize) throws GeneralSecurityException {
        KeyPairGenerator kpg;
        KeyPairGenerator keyPairGenerator = kpg = KeyPairGenerator.getInstance(algorithm, "BC");
        synchronized (keyPairGenerator) {
            kpg.initialize(keySize, _random);
        }
        return kpg.generateKeyPair();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyPair generateECKeypair(String curveId) throws GeneralSecurityException {
        KeyPairGenerator kpGen;
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)curveId);
        KeyPairGenerator keyPairGenerator = kpGen = KeyPairGenerator.getInstance("ECDSA", "BC");
        synchronized (keyPairGenerator) {
            kpGen.initialize((AlgorithmParameterSpec)spec, _random);
        }
        return kpGen.generateKeyPair();
    }

    public static final String retrieveCN(X509Certificate cert) throws CertificateException {
        return CertificateUtils.retrieveCertificateAttribute("cn", cert);
    }

    private static String retrieveCertificateAttribute(String attribute, X509Certificate cert) throws CertificateException {
        String subjectDN = cert.getSubjectDN().getName();
        int from = subjectDN.toLowerCase().indexOf(attribute + "=");
        if (from == -1) {
            throw new CertificateException("Certificate attribute '" + attribute + "' not found in certificate.");
        }
        int to = subjectDN.toLowerCase().indexOf(44, from += (attribute + "=").length());
        if (to == -1) {
            if (from == subjectDN.length()) {
                throw new CertificateException("Certificate attribute '" + attribute + "' is empty.");
            }
            to = subjectDN.length();
        }
        return subjectDN.substring(from, to).trim();
    }

    public static final X509Certificate readCertificateFromBytes(byte[] bytes) throws CertificateException, NoSuchProviderException {
        return CertificateUtils.readCertificateFromInputStream(new ByteArrayInputStream(bytes));
    }

    private static X509Certificate readCertificateFromInputStream(InputStream inputStream) throws CertificateException, NoSuchProviderException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(inputStream);
        return cert;
    }

    public static final PrivateKey readPrivateKeyFromBytes(byte[] bytes, String algorithm) throws CertificateException {
        PrivateKey privKey;
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
            privKey = KeyFactory.getInstance(algorithm, "BC").generatePrivate(spec);
        }
        catch (Exception e) {
            throw new CertificateException(e.toString());
        }
        return privKey;
    }

    public static final String certificateBase64Encoded(X509Certificate certificate) throws Exception {
        StringBuilder sb = new StringBuilder();
        byte[] base64EncodedCert = Base64Encoder.encode(certificate.getEncoded()).getBytes();
        sb.append(CERT_HEADER);
        sb.append(new String(base64EncodedCert));
        sb.append(CERT_FOOTER);
        return sb.toString();
    }

    public static final String certRequestBase64Encoded(PKCS10CertificationRequest certRequest) throws Exception {
        StringBuilder result = new StringBuilder();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream dos = ASN1OutputStream.create((OutputStream)baos);
        dos.writeObject((ASN1Encodable)certRequest.toASN1Structure());
        dos.close();
        baos.close();
        result.append(REQUEST_HEADER);
        result.append(Base64Encoder.encode(baos.toByteArray()));
        result.append(REQUEST_FOOTER);
        return result.toString();
    }

    public static final X509Certificate createCertificate(String subject, PublicKey publicKey, String issuer, PrivateKey privateKey) throws GeneralSecurityException {
        GregorianCalendar date = new GregorianCalendar();
        date.add(11, -1);
        Date notBefore = date.getTime();
        date.add(2, 11);
        Date notAfter = date.getTime();
        BigInteger serialNumber = new BigInteger(20, new SecureRandom());
        X500Name subject1 = new X500Name(subject);
        X500Name issuer1 = new X500Name(issuer);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer1, serialNumber, notBefore, notAfter, subject1, SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder(CertificateUtils.getInstance().getAlgorithm(privateKey));
        try {
            ContentSigner signer = builder.build(privateKey);
            byte[] certBytes = certBuilder.build(signer).getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (Exception e) {
            throw new GeneralSecurityException(e.getMessage(), e);
        }
    }

    public static final X509Certificate createSelfSignedCertificate(String issuer, PublicKey publicKey, PrivateKey privateKey) throws GeneralSecurityException {
        return CertificateUtils.createCertificate(issuer, publicKey, issuer, privateKey);
    }
}

