/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.securelistener.administration;

import java.util.Map;

public abstract class CommandModel {
    private final Map<String, String> headers;
    private final byte[] data;

    public CommandModel(Map<String, String> headers, byte[] data) {
        this.headers = headers;
        this.data = data;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getHeader(String key) {
        if (this.headers != null) {
            return this.headers.get(key);
        }
        return null;
    }

    public String getHeadersAsString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            builder.append(entry.getKey());
            builder.append(": ");
            builder.append(entry.getValue());
            builder.append("\r\n");
        }
        return builder.toString();
    }
}

