/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.applicationpart.patchinfo;

import java.text.ParseException;
import java.util.Objects;

public class Version
implements Comparable<Version> {
    private final int majorVersion;
    private final int minorVersion;
    private final int updateVersion;
    private final int releaseVersion;

    public Version(String versionString) throws ParseException {
        if (versionString == null || versionString.isEmpty()) {
            throw new ParseException("Can not parse empty or null.", 0);
        }
        try {
            String normalizedVersion = this.normalize(versionString);
            String[] versionSplit = normalizedVersion.split("\\.", 4);
            switch (versionSplit.length) {
                case 0: 
                case 1: {
                    this.majorVersion = this.toInt(versionSplit[0]);
                    this.minorVersion = 0;
                    this.updateVersion = 0;
                    this.releaseVersion = 0;
                    return;
                }
                case 2: {
                    this.majorVersion = this.toInt(versionSplit[0]);
                    this.minorVersion = this.toInt(versionSplit[1]);
                    this.updateVersion = 0;
                    this.releaseVersion = 0;
                    return;
                }
                case 3: {
                    this.majorVersion = this.toInt(versionSplit[0]);
                    this.minorVersion = this.toInt(versionSplit[1]);
                    this.updateVersion = this.toInt(versionSplit[2]);
                    this.releaseVersion = 0;
                    return;
                }
                case 4: {
                    this.majorVersion = this.toInt(versionSplit[0]);
                    this.minorVersion = this.toInt(versionSplit[1]);
                    this.updateVersion = this.toInt(versionSplit[2]);
                    this.releaseVersion = this.toInt(versionSplit[3], true);
                    return;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ParseException("Passed version (" + versionString + ") does not match '[MAJOR].[MINOR](.[UPDATE].[RELEASE])'.", 0);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getUpdateVersion() {
        return this.updateVersion;
    }

    public int getReleaseVersion() {
        return this.releaseVersion;
    }

    private int toInt(String value) {
        return this.toInt(value, false);
    }

    private int toInt(String value, boolean ignoreParsingError) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            if (ignoreParsingError) {
                return 0;
            }
            throw e;
        }
    }

    private String normalize(String versionString) {
        String normalizedVersion = this.normalize(versionString, '-');
        normalizedVersion = this.normalize(normalizedVersion, '_');
        normalizedVersion = this.normalize(normalizedVersion, '+');
        return normalizedVersion;
    }

    private String normalize(String versionString, char supportedSeparator) {
        int index = versionString.indexOf(supportedSeparator);
        if (index > 0) {
            String fixVersion = versionString.substring(0, index);
            String[] versionSplit = fixVersion.split("\\.");
            switch (versionSplit.length) {
                case 1: {
                    fixVersion = fixVersion + ".0.0";
                    break;
                }
                case 2: {
                    fixVersion = fixVersion + ".0";
                }
            }
            return fixVersion + "." + versionString.substring(index + 1);
        }
        return versionString;
    }

    private int comparePrimitiveNumber(int valueA, int valueB) {
        return valueA > valueB ? 1 : (valueA < valueB ? -1 : 0);
    }

    @Override
    public int compareTo(Version other) {
        int compareResult = this.comparePrimitiveNumber(this.majorVersion, other.majorVersion);
        if (compareResult == 0 && (compareResult = this.comparePrimitiveNumber(this.minorVersion, other.minorVersion)) == 0 && (compareResult = this.comparePrimitiveNumber(this.updateVersion, other.updateVersion)) == 0) {
            compareResult = this.comparePrimitiveNumber(this.releaseVersion, other.releaseVersion);
        }
        return compareResult;
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.updateVersion, this.releaseVersion);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version that = (Version)other;
        return Objects.equals(this.majorVersion, that.majorVersion) && Objects.equals(this.minorVersion, that.minorVersion) && Objects.equals(this.updateVersion, that.updateVersion) && Objects.equals(this.releaseVersion, that.releaseVersion);
    }

    public String toString() {
        return String.format("%d.%d.%d.%d", this.majorVersion, this.minorVersion, this.updateVersion, this.releaseVersion);
    }
}

