/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.api.wrapperconf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import shaded.org.apache.commons.configuration2.PropertiesConfiguration;
import shaded.org.apache.commons.configuration2.ex.ConfigurationException;

public class WrapperConf {
    private static final String LINE_SEPARATOR = "\n";
    public static final String DEFAULT_API_VERSION = "1.0";
    public static final int DEFAULT_CODE = 0;
    public static final int RESTART_CODE = 100;
    private static final String PROPERTY_RESTART_CODE = "wrapper.on_exit.100";
    private static final String PROPERTY_RESTART_RELOAD_CONFIGURATION = "wrapper.restart.reload_configuration";
    public static final String PROPERTY_JVM_EXECUTABLE = "wrapper.java.command";
    public static final String PROPERTY_OS_TYPE = "ponton.os.type";
    public static final String PROPERTY_NEW_JAVA_PATH = "ponton.new.java.path";
    public static final String PROPERTY_PATCH_JAVA_MIN_VERSION = "ponton.patch.java.min_version";
    public static final String PROPERTY_APP_MIN_VERSION = "ponton.app.min_version";
    public static final String PROPERTY_APP_AFTER_PATCH_VERSION = "ponton.app.after_patch_version";
    public static final String PROPERTY_APP_JAVA_MIN_VERSION = "ponton.app.java.min_version";
    public static final String PROPERTY_APP_JAVA_AFTER_PATCH_VERSION = "ponton.app.java.after_patch_version";
    public static final String PROPERTY_APP_ID = "ponton.app.id";
    public static final String PROPERTY_ADDON_ID = "ponton.addon.id";
    public static final String PROPERTY_ADDON_AFTER_PATCH_VERSION = "ponton.addon.after_patch_version";
    public static final String PROPERTY_ADDON_API_VERSION = "ponton.addon.api_version";
    public static final String PROPERTY_ADDON_CONFIG_VERSION = "ponton.addon.config_version";
    public static final String DEFAULT_WRAPPER_CONF_FOLDER = "launcher/conf/";
    public static final String WRAPPER_CONF_FILENAME = "wrapper.conf";
    public static final String WRAPPER_CONF_BACKUP_FILENAME = "wrapper.conf_app";
    private final PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();

    public WrapperConf(File wrapperConfFile) throws FileNotFoundException, IOException, ConfigurationException {
        try (FileInputStream inputStream = new FileInputStream(wrapperConfFile);){
            this.readWrapperConfFile(inputStream);
        }
    }

    public WrapperConf(InputStream inputStream) throws IOException, ConfigurationException {
        this.readWrapperConfFile(inputStream);
    }

    private void readWrapperConfFile(InputStream inputStream) throws IOException, ConfigurationException {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            this.propertiesConfiguration.read(reader);
        }
        this.propertiesConfiguration.getLayout().setLineSeparator(LINE_SEPARATOR);
    }

    public void writeTo(File wrapperConfFile) throws IOException, ConfigurationException {
        try (FileWriter fileWriter = new FileWriter(wrapperConfFile);){
            this.propertiesConfiguration.write(fileWriter);
        }
    }

    public String getProperty(String key) {
        return this.propertiesConfiguration.getString(key);
    }

    public void setProperty(String key, String value) {
        this.propertiesConfiguration.setProperty(key, value);
    }
}

