/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.api.content;

import de.ponton.application.update.api.content.IDiffEntry;
import de.ponton.application.update.api.content.ItemState;
import de.ponton.application.update.api.content.ItemType;
import java.nio.file.Path;
import java.util.Objects;

public abstract class DiffEntry
implements IDiffEntry {
    private final Path path;
    private final ItemState itemState;
    private final ItemType itemType;

    public DiffEntry(Path path, ItemState itemState, ItemType itemType) {
        Objects.requireNonNull(path, "Relative path can't be NULL.");
        Objects.requireNonNull(itemState, "Item state can't be NULL.");
        Objects.requireNonNull(itemType, "Item type can't be NULL.");
        this.path = path;
        this.itemState = itemState;
        this.itemType = itemType;
    }

    @Override
    public String getNormalizedPath() {
        String normalizedPath = this.path.toString().replaceAll("\\\\", "/");
        if (normalizedPath.startsWith("/")) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (normalizedPath.startsWith("/")) {
            throw new IllegalArgumentException("Cannot normalize path starting with more than 1 slash. [path=" + this.path.toAbsolutePath() + "].");
        }
        return normalizedPath;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public ItemState getItemState() {
        return this.itemState;
    }

    @Override
    public ItemType getItemType() {
        return this.itemType;
    }

    @Override
    public int compareTo(IDiffEntry anotherItem) {
        if (anotherItem == null) {
            return 1;
        }
        return this.path.compareTo(anotherItem.getPath());
    }

    @Override
    public String toExternalFormat() {
        return (Object)((Object)this.getItemState()) + "\t" + (Object)((Object)this.getItemType()) + "\t" + this.getNormalizedPath();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [itemState=" + (Object)((Object)this.itemState) + ", itemType=" + (Object)((Object)this.itemType) + ", path=" + this.path + "]";
    }
}

