/*
 * Decompiled with CFR 0.152.
 */
package de.ponton.application.update.api.communication;

import de.ponton.application.update.api.communication.ResultCode;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.commons.configuration2.PropertiesConfiguration;
import shaded.org.apache.commons.configuration2.ex.ConfigurationException;
import shaded.org.apache.commons.lang3.StringUtils;

public class CommunicationData {
    private static final String LINE_SEPARATOR = "\n";
    public static final String FILENAME = ".communication";
    public static final String DEFAULT_RELATIVE_PATH = "update/.communication";
    private static final String PROPERTY_RESULT_CODE = "patch.resultCode";
    private static final String PROPERTY_RESULT_DESCRIPTION = "patch.resultDescription";
    private static final String PROPERTY_PATCHS = "patch.patches";
    private static final String PROPERTY_OLD_JAVA_PATH = "old.java.path";
    private ResultCode resultCode = ResultCode.SUCCESS;
    private String resultDescription;
    private final List<String> patches = new ArrayList<String>();
    private String oldJavaPath;

    public CommunicationData(File communicationDataFile) throws IOException, ConfigurationException {
        this();
        this.readFrom(communicationDataFile);
    }

    public CommunicationData() {
    }

    private void readFrom(File communicationDataFile) throws IOException, ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.getLayout().setLineSeparator(LINE_SEPARATOR);
        try (FileReader fileReader = new FileReader(communicationDataFile);){
            propertiesConfiguration.read(fileReader);
        }
        this.clear();
        this.patches.addAll(propertiesConfiguration.getCollection(String.class, PROPERTY_PATCHS, new ArrayList(), new ArrayList()));
        this.resultCode = propertiesConfiguration.get(ResultCode.class, PROPERTY_RESULT_CODE);
        this.resultDescription = propertiesConfiguration.getString(PROPERTY_RESULT_DESCRIPTION);
        this.oldJavaPath = propertiesConfiguration.getString(PROPERTY_OLD_JAVA_PATH);
    }

    private void clear() {
        this.patches.clear();
        this.resultCode = null;
        this.resultDescription = null;
        this.oldJavaPath = null;
    }

    public void writeTo(File communicationDataFile) throws IOException, ConfigurationException {
        PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
        propertiesConfiguration.getLayout().setLineSeparator(LINE_SEPARATOR);
        propertiesConfiguration.clearProperty(PROPERTY_PATCHS);
        for (String patchFilename : this.patches) {
            propertiesConfiguration.addProperty(PROPERTY_PATCHS, patchFilename);
        }
        propertiesConfiguration.setProperty(PROPERTY_RESULT_CODE, this.resultCode.toString());
        propertiesConfiguration.setProperty(PROPERTY_RESULT_DESCRIPTION, this.resultDescription);
        if (StringUtils.isNotBlank(this.oldJavaPath)) {
            propertiesConfiguration.setProperty(PROPERTY_OLD_JAVA_PATH, this.oldJavaPath);
        }
        try (FileWriter fileWriter = new FileWriter(communicationDataFile);){
            propertiesConfiguration.write(fileWriter);
        }
    }

    public String getNextPatch() {
        if (this.patches.isEmpty()) {
            return null;
        }
        return this.patches.remove(0);
    }

    public void addNextPatch(String patchJarFileName) {
        this.patches.add(patchJarFileName);
    }

    public ResultCode getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultDescription() {
        return this.resultDescription;
    }

    public void setResultDescription(String resultDescription) {
        this.resultDescription = resultDescription;
    }

    public void setOldJavaPath(String oldJavaPath) {
        this.oldJavaPath = oldJavaPath;
    }

    public String getOldJavaPath() {
        return this.oldJavaPath;
    }
}

