/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.security.bc155;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;

public class CertificationRequestInfo
extends ASN1Object {
    ASN1Integer version = new ASN1Integer(0L);
    X500Name subject;
    SubjectPublicKeyInfo subjectPKInfo;
    ASN1Set attributes = null;

    public static CertificationRequestInfo getInstance(Object obj) {
        if (obj instanceof CertificationRequestInfo) {
            return (CertificationRequestInfo)((Object)obj);
        }
        if (obj != null) {
            return new CertificationRequestInfo(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public CertificationRequestInfo(X500Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        if (subject == null || pkInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
        this.subject = subject;
        this.subjectPKInfo = pkInfo;
        this.attributes = attributes;
    }

    public CertificationRequestInfo(X509Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        if (subject == null || pkInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
        this.subject = X500Name.getInstance((Object)subject.toASN1Primitive());
        this.subjectPKInfo = pkInfo;
        this.attributes = attributes;
    }

    public CertificationRequestInfo(ASN1Sequence seq) {
        this.version = (ASN1Integer)seq.getObjectAt(0);
        this.subject = X500Name.getInstance((Object)seq.getObjectAt(1));
        this.subjectPKInfo = SubjectPublicKeyInfo.getInstance((Object)seq.getObjectAt(2));
        if (seq.size() > 3) {
            ASN1TaggedObject tagobj = (ASN1TaggedObject)seq.getObjectAt(3);
            this.attributes = ASN1Set.getInstance((ASN1TaggedObject)tagobj, (boolean)false);
        }
        if (this.subject == null || this.version == null || this.subjectPKInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPKInfo;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.subject);
        v.add((ASN1Encodable)this.subjectPKInfo);
        if (this.attributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.attributes));
        }
        return new DERSequence(v);
    }
}

