/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SecurityFileReader {
    private static final String KEY = ".key";
    private static final String DER = ".der";
    private static final String CER = ".cer";
    private static final String PFX = ".pfx";
    private static final String P12 = ".p12";
    private static final String PKCS12 = "PKCS12";
    private static final String RSA = "RSA";
    private static final String X_509 = "X.509";
    private static final String BC = "BC";

    public SecurityFileReader() {
        BouncyCastleProvider bc = new BouncyCastleProvider();
        bc.put((Object)"Alg.Alias.Cipher.PBEWithSHAAnd3KeyTripleDES", (Object)"PBEWITHSHAAND3-KEYTRIPLEDES-CBC");
        bc.put((Object)"Alg.Alias.SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", (Object)"PBE/PKCS12");
        bc.put((Object)"Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", (Object)"PKCS12PBE");
        Security.addProvider((Provider)bc);
    }

    public List getSecurityObjects(String mainFileName, InputStream mainInputStream, String password, InputStream secondInputStream) throws Exception {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if ((mainFileName = mainFileName.toLowerCase()).endsWith(P12) || mainFileName.endsWith(PFX)) {
            result.addAll(this.getPKCS12(mainInputStream, password));
        } else if (mainFileName.endsWith(CER) || mainFileName.endsWith(DER)) {
            result.add(this.getCER(mainInputStream));
        } else if (mainFileName.endsWith(KEY)) {
            result.add(this.getPrivateKey(mainInputStream, secondInputStream, password));
        } else {
            throw new Exception("Unknown file type.");
        }
        return result;
    }

    private Object[] getPrivateKey(InputStream keyFile, InputStream certFile, String password) throws IOException, GeneralSecurityException {
        Object[] result = new Object[2];
        byte[] encKey = new byte[keyFile.available()];
        keyFile.read(encKey);
        EncryptedPrivateKeyInfo pInfo = new EncryptedPrivateKeyInfo(encKey);
        SecretKeyFactory keyFact = SecretKeyFactory.getInstance(pInfo.getAlgName(), BC);
        char[] pass = password != null ? password.toCharArray() : null;
        PBEKeySpec pbeSpec = new PBEKeySpec(pass);
        Cipher cipher = Cipher.getInstance(pInfo.getAlgName(), BC);
        cipher.init(2, (Key)keyFact.generateSecret(pbeSpec), pInfo.getAlgParameters());
        PKCS8EncodedKeySpec keySpec = pInfo.getKeySpec(cipher);
        PrivateKey privKey = KeyFactory.getInstance(RSA, BC).generatePrivate(keySpec);
        result[1] = privKey;
        CertificateFactory certfact = CertificateFactory.getInstance(X_509, BC);
        X509Certificate cert = (X509Certificate)certfact.generateCertificate(certFile);
        X509Certificate[] certs = new X509Certificate[]{cert};
        result[0] = certs;
        return result;
    }

    private Object[] getCER(InputStream fileInputStream) throws IOException, GeneralSecurityException {
        Object[] result = new Object[2];
        CertificateFactory fact = CertificateFactory.getInstance(X_509, BC);
        X509Certificate cert = (X509Certificate)fact.generateCertificate(fileInputStream);
        X509Certificate[] certs = new X509Certificate[]{cert};
        result[0] = certs;
        return result;
    }

    private List getPKCS12(InputStream fileInputStream, String password) throws IOException, GeneralSecurityException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        KeyStore p12store = KeyStore.getInstance(PKCS12, BC);
        char[] pass = password != null ? password.toCharArray() : new char[]{};
        p12store.load(fileInputStream, pass);
        Enumeration<String> alias = p12store.aliases();
        while (alias.hasMoreElements()) {
            Object[] temp = new Object[2];
            String element = alias.nextElement();
            Certificate[] certs = p12store.getCertificateChain(element);
            PrivateKey key = (PrivateKey)p12store.getKey(element, pass);
            temp[0] = certs;
            temp[1] = key;
            result.add(temp);
        }
        return result;
    }
}

