/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.security;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public abstract class GenericKeyStore {
    private KeyStore _keyStore;

    public void load() throws GeneralSecurityException {
        this._keyStore = KeyStore.getInstance(this.getKeyStoreType());
        char[] password = this.getKeyStorePassword();
        if (password == null || password.length == 0) {
            throw new KeyStoreException("Password for keystore required.");
        }
        try {
            this._keyStore.load(this.getKeyStoreInputStream(), password);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            msg = msg == null || msg.length() == 0 ? "." : ": " + msg;
            msg = "Unable to load keystore" + msg;
            KeyStoreException ke = new KeyStoreException(msg);
            ke.setStackTrace(e.getStackTrace());
            throw ke;
        }
    }

    public void store() throws KeyStoreException {
        try {
            this._keyStore.store(this.getKeyStoreOutputStream(), this.getKeyStorePassword());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            msg = msg == null || msg.length() == 0 ? "." : ": " + msg;
            msg = "Unable to store keystore" + msg;
            KeyStoreException ke = new KeyStoreException(msg);
            ke.setStackTrace(e.getStackTrace());
            throw ke;
        }
    }

    protected abstract InputStream getKeyStoreInputStream() throws FileNotFoundException;

    protected abstract OutputStream getKeyStoreOutputStream() throws FileNotFoundException;

    protected abstract char[] getKeyStorePassword();

    protected String getKeyStoreType() {
        return "JKS";
    }

    public void addPrivateKey(PrivateKey privateKey, char[] password, X509Certificate certificate, String alias, Date referenceDate) throws KeyStoreException, CertificateException {
        X509Certificate[] certChain = this.getCertificateChain(certificate);
        this.storePrivateKey(privateKey, password, certChain, alias, referenceDate);
    }

    private void storePrivateKey(PrivateKey privateKey, char[] password, X509Certificate[] certChain, String alias, Date referenceDate) throws CertificateException, KeyStoreException {
        try {
            GenericKeyStore.checkCertificate(certChain, referenceDate);
        }
        catch (GeneralSecurityException e) {
            CertificateException ce = new CertificateException(e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        this._keyStore.setKeyEntry(alias, privateKey, password, certChain);
        try {
            this.store();
        }
        catch (KeyStoreException e) {
            this._keyStore.deleteEntry(alias);
            throw e;
        }
    }

    public void addCertificate(String alias, X509Certificate cert, Date referenceDate) throws CertificateException, KeyStoreException {
        try {
            this.checkCertificate(cert, referenceDate);
        }
        catch (GeneralSecurityException e) {
            CertificateException ce = new CertificateException(e.getMessage());
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        this._keyStore.setCertificateEntry(alias, cert);
        try {
            this.store();
        }
        catch (KeyStoreException e) {
            this._keyStore.deleteEntry(alias);
            throw e;
        }
    }

    public void checkCertificate(X509Certificate certificate, Date referencedate) throws CertificateException, GeneralSecurityException {
        GenericKeyStore.checkCertificate(this.getCertificateChain(certificate), referencedate);
    }

    public static void checkCertificate(X509Certificate[] certChain, Date referenceDate) throws CertificateException, GeneralSecurityException {
        X509Certificate certificate = certChain[0];
        GenericKeyStore.checkValidity(certificate, referenceDate);
        for (int i = 1; i < certChain.length; ++i) {
            certificate = certChain[i];
            GenericKeyStore.checkValidity(certificate, referenceDate);
            GenericKeyStore.checkCertificate(certChain[i - 1], certificate);
        }
    }

    public static void checkCertificate(X509Certificate certificate, X509Certificate caCertificate) throws CertificateException, GeneralSecurityException {
        try {
            certificate.verify(caCertificate.getPublicKey());
        }
        catch (InvalidKeyException e) {
            String msg = e.getMessage();
            msg = msg == null || msg.length() == 0 ? "." : ": " + msg;
            msg = "Signing CA '" + caCertificate.getSubjectX500Principal().getName() + "' is not issuer of certificate '" + certificate.getSubjectDN().getName() + "'" + msg;
            CertificateException ce = new CertificateException(msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        catch (SignatureException e) {
            String msg = e.getMessage();
            msg = msg == null || msg.length() == 0 ? "." : ": " + msg;
            msg = "Signing CA '" + caCertificate.getSubjectX500Principal().getName() + "' is not issuer of certificate '" + certificate.getSubjectDN().getName() + "'" + msg;
            CertificateException ce = new CertificateException(msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    public static void checkValidity(X509Certificate certificate, Date referenceDate) throws CertificateException {
        try {
            certificate.checkValidity(referenceDate);
        }
        catch (CertificateExpiredException e) {
            String msg = e.getMessage();
            msg = msg == null || msg.length() == 0 ? "." : ": " + msg;
            msg = "Certificate '" + certificate.getSubjectX500Principal().getName() + "' is out of date" + msg;
            CertificateException ce = new CertificateException(msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
        catch (CertificateNotYetValidException e) {
            String msg = e.getMessage();
            msg = msg == null || msg.length() == 0 ? "." : ": " + msg;
            msg = "Certificate '" + certificate.getSubjectX500Principal().getName() + "' is not valid" + msg;
            CertificateException ce = new CertificateException(msg);
            ce.setStackTrace(e.getStackTrace());
            throw ce;
        }
    }

    public X509Certificate[] getCertificateChain(X509Certificate cert) throws KeyStoreException, CertificateException {
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        v.add(cert);
        X500Principal subject = cert.getSubjectX500Principal();
        X500Principal issuer = cert.getIssuerX500Principal();
        while (!issuer.equals(subject)) {
            X509Certificate issuerCert = this.getIssuerCertificate(cert);
            if (issuerCert == null) {
                throw new CertificateException("No certificate for CA '" + issuer.getName() + "' found.");
            }
            try {
                issuerCert.checkValidity();
            }
            catch (GeneralSecurityException e) {
                String msg = e.getMessage();
                msg = msg == null || msg.length() == 0 ? "." : ": " + msg;
                msg = "Certificate for '" + issuerCert.getIssuerX500Principal().getName() + "' is out of date" + msg;
                CertificateException ce = new CertificateException(msg);
                ce.setStackTrace(e.getStackTrace());
                throw ce;
            }
            v.add(issuerCert);
            subject = issuerCert.getSubjectX500Principal();
            issuer = issuerCert.getIssuerX500Principal();
            cert = issuerCert;
        }
        X509Certificate[] certChain = new X509Certificate[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            certChain[i] = (X509Certificate)v.get(i);
        }
        return certChain;
    }

    private X509Certificate getIssuerCertificate(X509Certificate cert) {
        X500Principal issuer = cert.getIssuerX500Principal();
        Enumeration<Certificate> certificates = this.certificates();
        while (certificates.hasMoreElements()) {
            X509Certificate aCert = (X509Certificate)certificates.nextElement();
            if (!aCert.getSubjectX500Principal().equals(issuer)) continue;
            return aCert;
        }
        return null;
    }

    public Enumeration<Certificate> certificates() {
        try {
            Vector<Certificate> certs = new Vector<Certificate>(this._keyStore.size(), 1);
            Enumeration<String> aliases = this._keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this._keyStore.isCertificateEntry(alias)) continue;
                certs.add(this._keyStore.getCertificate(alias));
            }
            return certs.elements();
        }
        catch (KeyStoreException e) {
            return new Vector().elements();
        }
    }
}

