/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.security;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class Extension {
    public static final byte VALUE_SEPARATOR_BYTE = 0;
    public static final String VALUE_SEPARATOR_STRING = "\r";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private String _oid;
    private boolean _critical;
    private byte[] _bytes;

    public Extension(String oid, String commonFormat) {
        this(oid, false, commonFormat);
    }

    public Extension(String oid, boolean critical, String commonFormat) {
        this(oid, critical, Extension.buildValues(commonFormat));
    }

    private static String[] buildValues(String commonFormat) {
        if (commonFormat == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        int fromIndex = 0;
        int toIndex = commonFormat.indexOf(VALUE_SEPARATOR_STRING, fromIndex);
        while (toIndex != -1) {
            values.add(commonFormat.substring(fromIndex, toIndex));
            fromIndex = toIndex + VALUE_SEPARATOR_STRING.length();
            toIndex = commonFormat.indexOf(VALUE_SEPARATOR_STRING, fromIndex);
        }
        if (fromIndex <= commonFormat.length()) {
            values.add(commonFormat.substring(fromIndex));
        }
        return values.toArray(new String[values.size()]);
    }

    public Extension(String oid, byte[] bytes) {
        this(oid, false, bytes);
    }

    public Extension(String oid, boolean critical, byte[] bytes) {
        this._oid = oid;
        this._critical = critical;
        this._bytes = bytes;
    }

    public Extension(String oid, String[] values) {
        this(oid, false, values);
    }

    public Extension(String oid, boolean critical, String[] values) {
        this._oid = oid;
        this._critical = critical;
        if (values != null && values.length > 0) {
            try {
                byte[] bytes = values[0].getBytes(DEFAULT_CHARSET_NAME);
                for (int i = 1; i < values.length; ++i) {
                    bytes = this.unite(bytes, new byte[]{0});
                    bytes = this.unite(bytes, values[i].getBytes(DEFAULT_CHARSET_NAME));
                }
                this._bytes = bytes;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private byte[] unite(byte[] bytes1, byte[] bytes2) {
        int i;
        byte[] result = new byte[bytes1.length + bytes2.length];
        for (i = 0; i < bytes1.length; ++i) {
            result[i] = bytes1[i];
        }
        for (i = 0; i < bytes2.length; ++i) {
            result[i + bytes1.length] = bytes2[i];
        }
        return result;
    }

    private byte[] getBulk(byte[] bytes, int offset, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bytes[offset + i];
        }
        return result;
    }

    public String getOID() {
        return this._oid;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public boolean getCritical() {
        return this._critical;
    }

    public String getExtensionCommonFormat() {
        String commonFormat = null;
        String[] values = this.getValueAsStrings();
        if (values != null) {
            commonFormat = "";
            for (int j = 0; j < values.length; ++j) {
                commonFormat = commonFormat + values[j] + VALUE_SEPARATOR_STRING;
            }
        }
        return commonFormat;
    }

    public String[] getValueAsStrings() {
        try {
            return this.getValueAsStrings(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String getValueAsString() {
        String[] values = this.getValueAsStrings();
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getValueAsStrings(String charsetName) throws UnsupportedEncodingException {
        ByteBuffer[] byteBuffers = this.getValueAsBytes();
        if (byteBuffers == null) {
            return null;
        }
        String[] values = new String[byteBuffers.length];
        for (int i = 0; i < byteBuffers.length; ++i) {
            ByteBuffer bytes = byteBuffers[i];
            values[i] = new String(bytes.array(), charsetName);
        }
        return values;
    }

    public ByteBuffer[] getValueAsBytes() {
        if (this._bytes == null) {
            return null;
        }
        int offset = 0;
        int length = 0;
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
        for (int i = 0; i < this._bytes.length; ++i) {
            if (this._bytes[i] != 0) continue;
            length = i - offset;
            if (length > 0) {
                values.add(ByteBuffer.wrap(this.getBulk(this._bytes, offset, length)));
            }
            offset = i + 1;
        }
        if (offset < this._bytes.length) {
            values.add(ByteBuffer.wrap(this.getBulk(this._bytes, offset, this._bytes.length - offset)));
        }
        return values.toArray(new ByteBuffer[values.size()]);
    }
}

