/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.security;

import de.pontonconsulting.security.Extension;
import de.pontonconsulting.security.bc155.PKCS10CertificationRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;

public class CertificateRequest {
    public static final String KEY_SEPARATOR = "=";
    private static final String BOUNCY_CASTLE = "BC";
    private static final String ALGORITHM = "SHA1WithRSA";
    private final PKCS10CertificationRequest _certRequest;
    private final X500Name _subject;
    private final PublicKey _publicKey;

    public CertificateRequest(X500Name subject, PublicKey publicKey, PrivateKey signingKey) throws GeneralSecurityException, OperatorCreationException {
        this(subject, null, publicKey, signingKey);
    }

    public CertificateRequest(X500Name subject, Extension[] extensions, PublicKey publicKey, PrivateKey signingKey) throws GeneralSecurityException, OperatorCreationException {
        this._subject = subject;
        this._publicKey = publicKey;
        ContentSigner signer = new JcaContentSignerBuilder(ALGORITHM).build(signingKey);
        this._certRequest = new PKCS10CertificationRequest(ALGORITHM, new X509Name(subject.toString()), publicKey, CertificateRequest.createASN1Set(extensions), signingKey, BOUNCY_CASTLE);
    }

    private void addAttributes(PKCS10CertificationRequestBuilder csrbuilder, Extension[] extensions) {
        if (extensions != null) {
            for (Extension extension : extensions) {
                csrbuilder.setAttribute(new ASN1ObjectIdentifier(extension.getOID()), (ASN1Encodable)new DERUTF8String(extension.getExtensionCommonFormat()));
            }
        }
    }

    public CertificateRequest(byte[] der) throws GeneralSecurityException, IOException {
        this._certRequest = new PKCS10CertificationRequest(der);
        this._subject = this._certRequest.getCertificationRequestInfo().getSubject();
        this._publicKey = this._certRequest.getPublicKey();
    }

    public ASN1Set getASN1Set() {
        return this._certRequest.getCertificationRequestInfo().getAttributes();
    }

    public X500Name getSubject() {
        return this._subject;
    }

    public String getSubjectCN() {
        RDN cn = this._subject.getRDNs(BCStyle.CN)[0];
        return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
    }

    public byte[] getDER() throws IOException {
        return this._certRequest.getEncoded();
    }

    public PublicKey getPublicKey() throws GeneralSecurityException {
        return this._publicKey;
    }

    public static Extension[] createExtensions(ASN1Set set) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        if (set != null) {
            Enumeration derStrings = set.getObjects();
            while (derStrings.hasMoreElements()) {
                DERUTF8String element = (DERUTF8String)derStrings.nextElement();
                String content = element.getString();
                int keySepIndex = content.indexOf(KEY_SEPARATOR);
                if (keySepIndex == -1 || keySepIndex >= content.length()) continue;
                String key = content.substring(0, keySepIndex);
                extensions.add(new Extension(key, content.substring(keySepIndex + KEY_SEPARATOR.length())));
            }
        }
        return extensions.toArray(new Extension[extensions.size()]);
    }

    public static ASN1Set createASN1Set(Extension[] extensions) {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        if (extensions != null) {
            for (int i = 0; i < extensions.length; ++i) {
                Extension extension = extensions[i];
                String parameter = extension.getOID() + KEY_SEPARATOR;
                String values = extension.getExtensionCommonFormat();
                if (values != null) {
                    parameter = parameter + values;
                }
                vector.add((ASN1Encodable)new DERUTF8String(parameter));
            }
        }
        return new DERSet(vector);
    }
}

