/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class BIKEUtils {
    BIKEUtils() {
    }

    static int getHammingWeight(byte[] bytes) {
        int hammingWeight = 0;
        for (int i = 0; i < bytes.length; ++i) {
            hammingWeight += bytes[i];
        }
        return hammingWeight;
    }

    static void fromBitArrayToByteArray(byte[] out, byte[] in, int inOff, int inLen) {
        int count = 0;
        int pos = 0;
        long len = inLen;
        while ((long)count < len) {
            int j;
            int b;
            if (count + 8 >= inLen) {
                b = in[inOff + count];
                for (j = inLen - count - 1; j >= 1; --j) {
                    b |= in[inOff + count + j] << j;
                }
                out[pos] = (byte)b;
            } else {
                b = in[inOff + count];
                for (j = 7; j >= 1; --j) {
                    b |= in[inOff + count + j] << j;
                }
                out[pos] = (byte)b;
            }
            count += 8;
            ++pos;
        }
    }

    static void generateRandomByteArray(byte[] res, int size, int weight, Xof digest) {
        byte[] buf = new byte[4];
        for (int i = weight - 1; i >= 0; --i) {
            digest.doOutput(buf, 0, 4);
            long temp = (long)Pack.littleEndianToInt(buf, 0) & 0xFFFFFFFFL;
            temp = temp * (long)(size - i) >> 32;
            int rand_pos = (int)temp;
            if (BIKEUtils.CHECK_BIT(res, rand_pos += i) != 0) {
                rand_pos = i;
            }
            BIKEUtils.SET_BIT(res, rand_pos);
        }
    }

    protected static int CHECK_BIT(byte[] tmp, int position) {
        int index = position / 8;
        int pos = position % 8;
        return tmp[index] >>> pos & 1;
    }

    protected static void SET_BIT(byte[] tmp, int position) {
        int index = position / 8;
        int pos = position % 8;
        int n = index;
        tmp[n] = (byte)((long)tmp[n] | 1L << (int)((long)pos));
    }
}

