/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.message;

import de.pontonconsulting.xmlpipe.message.NoBackendEnvelopeException;
import de.pontonconsulting.xmlpipe.message.SAXPath;
import de.pontonconsulting.xmlpipe.message.StopParsingException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXEnvelopeParser
extends DefaultHandler {
    private static final String EMPTY = "";
    private static final String XPATH_SEPARATOR = "/";
    private static final String ROOT_ELEMENT_NAME = "Envelope";
    private final HashMap _customXPaths = new HashMap();
    private boolean _backendEnvelope = true;
    private final ArrayList _xpath = new ArrayList();
    private int _xpathLevel = 0;
    private boolean _firstElement = true;
    private String _currentXPath = "";
    private final HashMap _namespaces = new HashMap();
    private String _stopOnElement;

    public SAXEnvelopeParser() {
        this._xpath.add(0, this._currentXPath);
    }

    public void addCustomXPath(String id, String xpath, boolean repeatable) {
        this._customXPaths.put(id, new SAXPath(xpath, repeatable));
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this._namespaces.put(prefix, uri);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this._backendEnvelope) {
            this._currentXPath = (String)this._xpath.get(this._xpathLevel) + XPATH_SEPARATOR + localName;
            this._xpath.add(++this._xpathLevel, this._currentXPath);
            if (this._stopOnElement != null && this._stopOnElement.equals(this._currentXPath)) {
                throw new StopParsingException("Stop element reached");
            }
            if (this._firstElement) {
                this._firstElement = false;
                if (!localName.equals(ROOT_ELEMENT_NAME) || !namespaceURI.equals(EMPTY)) {
                    this._backendEnvelope = false;
                    throw new NoBackendEnvelopeException("Backend envelope not found.");
                }
            }
            for (SAXPath xpath : this._customXPaths.values()) {
                xpath.startElement(localName, this._xpathLevel, this._currentXPath, atts);
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        --this._xpathLevel;
        boolean result = false;
        Iterator iter = this._customXPaths.values().iterator();
        while (iter.hasNext() && !result) {
            SAXPath xpath = (SAXPath)iter.next();
            result = xpath.endElement();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        for (SAXPath xpath : this._customXPaths.values()) {
            xpath.handleText(text);
        }
    }

    public String getValue(String id) {
        SAXPath xpath = (SAXPath)this._customXPaths.get(id);
        return xpath.getValue();
    }

    public String[] getValues(String id) {
        SAXPath xpath = (SAXPath)this._customXPaths.get(id);
        String[] values = new String[xpath.getValueCount()];
        for (int i = 0; i < xpath.getValueCount(); ++i) {
            values[i] = xpath.getValue(i);
        }
        return values;
    }

    public boolean elementsFound() {
        boolean found = true;
        for (SAXPath xpath : this._customXPaths.values()) {
            found = found && xpath.isFound();
        }
        return found;
    }

    protected HashMap getResults() {
        return this._customXPaths;
    }

    public void stopOnElement(String elementPath) {
        this._stopOnElement = elementPath;
    }

    protected boolean isBackendEnvelope() {
        return this._backendEnvelope;
    }

    public String getCharEncoding() {
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new ByteArrayInputStream(EMPTY.getBytes()));
    }
}

