/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.util;

public class StringUtils {
    public static final String EMPTY = "";
    public static final String SEPARATOR_CHAR = ";";
    public static final String ESCAPE_CHAR = "\\";

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String join(String[] strings) {
        return StringUtils.join(strings, SEPARATOR_CHAR);
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(String[] array, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (array == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return EMPTY;
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i].replaceAll(SEPARATOR_CHAR, "\\;"));
        }
        return buf.toString();
    }

    public static String[] listToStringArray(String list) {
        return StringUtils.listToStringArray(list, ESCAPE_CHAR, SEPARATOR_CHAR);
    }

    private static String[] listToStringArray(String str, String escapeChar, String separatorChar) {
        String regularExpressionSpecialChars = "/.*+?|()[]{}\\";
        String escapedEscapeChar = escapeChar;
        if ("/.*+?|()[]{}\\".indexOf(escapeChar) != -1) {
            escapedEscapeChar = ESCAPE_CHAR + escapeChar;
        }
        String[] temp = str.split("(?<!" + escapedEscapeChar + ")" + separatorChar, -1);
        String[] result = new String[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            result[i] = temp[i].replaceAll(escapedEscapeChar + separatorChar, separatorChar);
        }
        return result;
    }
}

