/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.adapter.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BufferedFileInputStream
extends InputStream {
    private final RandomAccessFile _file;
    private long _mark;
    private long _readLimit;
    private final byte[] _buffer = new byte[16384];
    private int _bufferOffset;
    private int _bufferSize;
    private long _fileSize;
    private long _bufferStartOffset;

    public BufferedFileInputStream(File file) throws FileNotFoundException {
        this._file = new RandomAccessFile(file, "r");
    }

    public BufferedFileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    @Override
    public synchronized void mark(int readlimit) {
        this._readLimit = readlimit;
        this._mark = this._bufferStartOffset + (long)this._bufferOffset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this._readLimit < this._file.getFilePointer() - (long)this._bufferOffset) {
            throw new IOException("read limit exceeded");
        }
        this._file.seek(this._mark);
        this._bufferOffset = 0;
        this._bufferSize = 0;
    }

    @Override
    public int read() throws IOException {
        if (this._bufferSize - this._bufferOffset < 1) {
            this._bufferStartOffset = this._file.getFilePointer();
            this._bufferSize = this._file.read(this._buffer);
            if (this._bufferSize == -1) {
                return -1;
            }
            this._bufferOffset = 0;
        }
        return this._buffer[this._bufferOffset++] & 0xFF;
    }

    @Override
    public int available() throws IOException {
        this._fileSize = this._file.length();
        return (int)(this._fileSize - this._bufferStartOffset - (long)this._bufferOffset);
    }

    @Override
    public void close() throws IOException {
        this._file.close();
    }

    @Override
    public long skip(long n) throws IOException {
        this._bufferSize = 0;
        return this._file.skipBytes((int)(n - (long)(this._bufferSize - this._bufferOffset)));
    }
}

