/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.tokenizer;

import java.util.Optional;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.TokenizerDefinition;
import org.apache.camel.model.TokenizerImplementationDefinition;
import org.apache.camel.model.tokenizer.LangChain4jTokenizerDefinition;
import org.apache.camel.processor.TokenizerProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenizerReifier<T extends TokenizerDefinition>
extends ProcessorReifier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(TokenizerReifier.class);
    private static final String TOKENIZER_PATH = "META-INF/services/org/apache/camel/tokenizer/";

    public TokenizerReifier(Route route, T definition) {
        super(route, definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(false);
        FactoryFinder factoryFinder = this.camelContext.getCamelContextExtension().getFactoryFinder(TOKENIZER_PATH);
        Optional tokenize = factoryFinder.newInstance(((TokenizerDefinition)this.definition).tokenizerName(), Tokenizer.class);
        if (tokenize.isEmpty()) {
            throw new RuntimeCamelException("Cannot find a tokenizer named: " + ((TokenizerDefinition)this.definition).tokenizerName() + " in the classpath");
        }
        Tokenizer tokenizer = (Tokenizer)tokenize.get();
        LOG.info("Creating a tokenizer of type {}", (Object)tokenizer.getClass().getName());
        this.configure(tokenizer);
        return new TokenizerProcessor(childProcessor, tokenizer);
    }

    protected void configure(Tokenizer tokenizer) {
        TokenizerImplementationDefinition tokenizerImplementation = ((TokenizerDefinition)this.definition).getTokenizerImplementation();
        Tokenizer.Configuration configuration = tokenizerImplementation.configuration();
        if (configuration == null) {
            configuration = tokenizer.newConfiguration();
            if (tokenizerImplementation instanceof LangChain4jTokenizerDefinition) {
                LangChain4jTokenizerDefinition ltd = (LangChain4jTokenizerDefinition)tokenizerImplementation;
                configuration.setMaxOverlap(Integer.valueOf(ltd.getMaxOverlap()).intValue());
                configuration.setMaxTokens(Integer.valueOf(ltd.getMaxTokens()).intValue());
                configuration.setType(ltd.getTokenizerType());
            }
        }
        tokenizer.configure(configuration);
    }
}

