/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util;

import de.pontonconsulting.common.encoding.Base64Encoder;
import de.pontonconsulting.xmlpipe.util.MimeMultipartUtils;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axiom.attachments.lifecycle.DataHandlerExt;
import org.apache.axis2.saaj.SOAPMessageImpl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SOAPMessageUtils {
    private static final Log LOG = LogFactory.getLog((String)"Messenger.SOAPMessageUtils");
    private static final String ENCODING_BASE64 = "base64";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(SOAPMessage soapMessage, File headerFile, File messageFile) {
        FilterOutputStream outSoapMessage = null;
        try {
            try (BufferedOutputStream outHeaders = new BufferedOutputStream(Files.newOutputStream(headerFile.toPath(), new OpenOption[0]));
                 ObjectOutputStream objectOutHeaders = new ObjectOutputStream(outHeaders);){
                outSoapMessage = new BufferedOutputStream(Files.newOutputStream(messageFile.toPath(), new OpenOption[0]));
                Map<String, String> mimeHeaders = MimeMultipartUtils.convertMimeHeadersToHashMap(soapMessage.getMimeHeaders());
                if (soapMessage.countAttachments() == 0) {
                    mimeHeaders.put("Content-Transfer-Encoding", ENCODING_BASE64);
                    outSoapMessage = new Base64Encoder(outSoapMessage);
                }
                objectOutHeaders.writeObject(mimeHeaders);
                soapMessage.writeTo((OutputStream)outSoapMessage);
            }
            IOUtils.closeQuietly((Closeable)outSoapMessage, exception -> LOG.error((Object)("Error occurs while closing message file '" + messageFile.getPath() + "'."), (Throwable)exception));
        }
        catch (Exception ex) {
            LOG.warn((Object)ex);
        }
        finally {
            IOUtils.closeQuietly(outSoapMessage, exception -> LOG.error((Object)("Error occurs while closing message file '" + messageFile.getPath() + "'."), (Throwable)exception));
        }
    }

    public static void purgeAttachments(SOAPMessage soapMessage) {
        if (soapMessage instanceof SOAPMessageImpl) {
            Iterator iterator = soapMessage.getAttachments();
            while (iterator.hasNext()) {
                SOAPMessageUtils.purgeAttachment((AttachmentPart)iterator.next());
            }
        }
    }

    private static void purgeAttachment(AttachmentPart attachment) {
        try {
            if (attachment.getDataHandler() instanceof DataHandlerExt) {
                DataHandlerExt attachmentHandler = (DataHandlerExt)attachment.getDataHandler();
                attachmentHandler.purgeDataSource();
            }
        }
        catch (IOException | SOAPException throwable) {
            // empty catch block
        }
    }
}

