/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util;

import de.pontonconsulting.common.activation.MimeTypeMapper;
import de.pontonconsulting.xmlpipe.message.XpMessage;
import de.pontonconsulting.xmlpipe.message.XpMessageAttachment;
import de.pontonconsulting.xmlpipe.util.IOUtil;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MimeMultipartUtils {
    public static final Logger LOG = LogManager.getLogger((String)"Messenger.MimeMultipartUtils");
    protected static final byte[] NEWLINE = "\r\n".getBytes();
    protected static final byte[] COLON = ": ".getBytes();
    public static final String SMIME_TYPE = "smime-type";
    public static final String SMIME_TYPE_SIGNED = "signed-data";
    public static final String SMIME_TYPE_ENVELOPED = "enveloped-data";
    public static final String SMIME_TYPE_COMPRESSED = "compressed-data";
    public static final String APP_PKCS7 = "application/pkcs7-mime";
    public static final String APP_X_PKCS7 = "application/x-pkcs7-mime";
    public static final String MULTIPART_SIGNED = "multipart/signed";
    private static final String DAT = ".dat";

    private MimeMultipartUtils() {
    }

    public static MimeHeaders createMimeHeader(Part mimepart) {
        if (mimepart == null) {
            return null;
        }
        MimeHeaders mimeHeaders = new MimeHeaders();
        try {
            Enumeration headersEnum = mimepart.getAllHeaders();
            while (headersEnum.hasMoreElements()) {
                Header header = (Header)headersEnum.nextElement();
                if (header == null) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}: {}", (Object)header.getName(), (Object)header.getValue());
                }
                mimeHeaders.addHeader(header.getName(), header.getValue());
            }
        }
        catch (MessagingException ex) {
            LOG.warn((Object)-1, (Throwable)ex);
        }
        return mimeHeaders;
    }

    public static InternetHeaders createIntenetHeaders(Part mimepart) {
        if (mimepart == null) {
            return null;
        }
        InternetHeaders internetHeaders = new InternetHeaders();
        try {
            Enumeration headers = mimepart.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                internetHeaders.addHeader(header.getName(), header.getValue());
            }
        }
        catch (MessagingException ex) {
            LOG.warn((Object)-1, (Throwable)ex);
        }
        return internetHeaders;
    }

    public static void writeHeadersFile(File headersFile, MimeHeaders mimeHeaders) {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(Files.newOutputStream(headersFile.toPath(), new OpenOption[0]));
            Iterator headers = mimeHeaders.getAllHeaders();
            while (headers.hasNext()) {
                MimeHeader header = (MimeHeader)headers.next();
                ((OutputStream)out).write(header.getName().getBytes());
                ((OutputStream)out).write(COLON);
                ((OutputStream)out).write(header.getValue().getBytes());
                ((OutputStream)out).write(NEWLINE);
            }
        }
        catch (Exception ex) {
            try {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static void writeHeadersFile(File headersFile, InternetHeaders internetHeaders) {
        if (internetHeaders == null) {
            return;
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(Files.newOutputStream(headersFile.toPath(), new OpenOption[0]));
            Enumeration headers = internetHeaders.getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                ((OutputStream)out).write(header.getName().getBytes());
                ((OutputStream)out).write(COLON);
                ((OutputStream)out).write(header.getValue().getBytes());
                ((OutputStream)out).write(NEWLINE);
            }
        }
        catch (Exception ex) {
            try {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static ContentDisposition getContentDisposition(BodyPart bodyPart) {
        if (bodyPart == null) {
            return null;
        }
        try {
            String[] disposition = bodyPart.getHeader("Content-Disposition");
            if (disposition != null && disposition.length > 0) {
                return new ContentDisposition(disposition[0]);
            }
        }
        catch (MessagingException ex) {
            LOG.error(ex.getMessage());
        }
        return null;
    }

    public static String getContentTypeString(Part bodyPart) {
        if (bodyPart == null) {
            return null;
        }
        String result = null;
        try {
            result = bodyPart.getContentType();
        }
        catch (Exception ex) {
            LOG.error((Object)-1, (Throwable)ex);
            try {
                String[] ctHeader = bodyPart.getHeader("Content-Type");
                if (ctHeader != null && ctHeader.length > 0) {
                    result = ctHeader[0];
                }
            }
            catch (Exception ex2) {
                LOG.error((Object)-1, (Throwable)ex2);
            }
        }
        return result;
    }

    public static ContentType getContentType(Part bodyPart) {
        if (bodyPart == null) {
            return null;
        }
        ContentType result = null;
        try {
            String contentType = bodyPart.getContentType();
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                result = new ContentType(contentType);
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        if (result == null) {
            try {
                String[] ctHeader = bodyPart.getHeader("Content-Type");
                if (ctHeader != null && ctHeader.length > 0) {
                    result = new ContentType(ctHeader[0]);
                }
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage());
            }
        }
        return result;
    }

    public static void saveAsXpAttachment(XpMessage xpMessage, BodyPart bodyPart) {
        if (xpMessage == null) {
            return;
        }
        if (bodyPart == null) {
            return;
        }
        ContentType contentType = MimeMultipartUtils.getContentType((Part)bodyPart);
        ContentDisposition contentDisposition = MimeMultipartUtils.getContentDisposition(bodyPart);
        File workFolder = xpMessage.getCurrentContentReferenceFolder();
        File attachmentFolder = new File(workFolder, "attachments");
        attachmentFolder.mkdir();
        String attachmentFilename = MimeMultipartUtils.determineAttachmentFilename(xpMessage, contentDisposition, contentType);
        File attachmentFile = new File(attachmentFolder, attachmentFilename);
        try {
            MimeMultipartUtils.saveBodyPartToFile(bodyPart, attachmentFile);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            throw new IllegalArgumentException(ex.getMessage());
        }
        XpMessageAttachment attachment = null;
        attachment = contentType != null ? new XpMessageAttachment(attachmentFile, contentType.getBaseType()) : new XpMessageAttachment(attachmentFile);
        xpMessage.addAttachment(attachment);
    }

    public static boolean isSMIMECompressed(Part mimePart) {
        return MimeMultipartUtils.isSMIMECompressed(MimeMultipartUtils.getContentTypeString(mimePart));
    }

    public static boolean isSMIMECompressed(String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return false;
        }
        if (contentType.toLowerCase().startsWith(APP_PKCS7)) {
            if (contentType.indexOf(59) != -1) {
                StringTokenizer tokens = new StringTokenizer(contentType.substring(contentType.indexOf(59)), ";");
                while (tokens.hasMoreTokens()) {
                    String param = tokens.nextToken().trim();
                    if (!param.toLowerCase().startsWith(SMIME_TYPE) || param.indexOf(61) == -1) continue;
                    String value = param.substring(param.indexOf(61) + 1);
                    return value.trim().equalsIgnoreCase(SMIME_TYPE_COMPRESSED) || value.trim().equalsIgnoreCase(SMIME_TYPE_ENVELOPED);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean isSMIMEEncrypted(Part mimePart) throws ParseException {
        return MimeMultipartUtils.isSMIMEEncrypted(MimeMultipartUtils.getContentTypeString(mimePart));
    }

    public static boolean isSMIMEEncrypted(String contentTypeValue) throws ParseException {
        if (StringUtils.isBlank((CharSequence)contentTypeValue)) {
            return false;
        }
        ContentType contentType = new ContentType(contentTypeValue.toLowerCase());
        String baseType = contentType.getBaseType();
        if (baseType.equals(APP_PKCS7) || baseType.equals(APP_X_PKCS7)) {
            String param = contentType.getParameter(SMIME_TYPE);
            if (StringUtils.isNotBlank((CharSequence)param)) {
                return param.equals(SMIME_TYPE_ENVELOPED);
            }
            return true;
        }
        return false;
    }

    public static boolean isSMIMESigned(Part mimeMessage) throws ParseException {
        return MimeMultipartUtils.isSMIMESigned(MimeMultipartUtils.getContentTypeString(mimeMessage));
    }

    public static boolean isSMIMESigned(String contentTypeValue) throws ParseException {
        if (StringUtils.isBlank((CharSequence)contentTypeValue)) {
            return false;
        }
        ContentType contentType = new ContentType(contentTypeValue.toLowerCase());
        String baseType = contentType.getBaseType();
        if (baseType.equals(MULTIPART_SIGNED) || baseType.equals(APP_PKCS7) || baseType.startsWith(APP_X_PKCS7)) {
            String param = contentType.getParameter(SMIME_TYPE);
            if (StringUtils.isNotBlank((CharSequence)param)) {
                return param.equals(SMIME_TYPE_SIGNED);
            }
            return true;
        }
        return false;
    }

    public static void saveAsXpPayload(XpMessage xpMessage, BodyPart bodyPart) {
        ContentType contentType = MimeMultipartUtils.getContentType((Part)bodyPart);
        ContentDisposition contentDisposition = MimeMultipartUtils.getContentDisposition(bodyPart);
        File workFolder = xpMessage.getCurrentContentReferenceFolder();
        String payloadFilename = MimeMultipartUtils.determinePayloadFilenameAndSetOriginalFilename(xpMessage, contentDisposition, contentType);
        File payloadFile = new File(workFolder, payloadFilename);
        try {
            MimeMultipartUtils.saveBodyPartToFile(bodyPart, payloadFile);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        xpMessage.setCurrentContentReference(payloadFile);
        if (contentType != null) {
            xpMessage.setCurrentContentType(contentType.getBaseType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBodyPartToFile(BodyPart bodyPart, File file) throws IOException, MessagingException {
        if (bodyPart == null) {
            return;
        }
        InputStream in = null;
        BufferedOutputStream out = new BufferedOutputStream(new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));
        try {
            in = bodyPart.getInputStream();
            IOUtil.write(in, out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static String determineAttachmentFilename(XpMessage xpMessage, ContentDisposition contentDisposition, ContentType contentType) {
        String contentDispositionFilename;
        if (contentDisposition != null && StringUtils.isNotBlank((CharSequence)(contentDispositionFilename = contentDisposition.getParameter("filename")))) {
            String decodedFilename;
            try {
                decodedFilename = MimeUtility.decodeText((String)contentDispositionFilename.trim());
            }
            catch (UnsupportedEncodingException ex) {
                LOG.warn(ex.getMessage());
                decodedFilename = contentDispositionFilename.trim();
            }
            return decodedFilename;
        }
        String fileExtension = DAT;
        if (contentType != null) {
            fileExtension = MimeTypeMapper.getExtension(contentType.getBaseType());
        }
        return xpMessage.getDatabaseId() + "-" + (xpMessage.getAttachments().size() + 1) + fileExtension;
    }

    private static String determinePayloadFilenameAndSetOriginalFilename(XpMessage xpMessage, ContentDisposition contentDisposition, ContentType contentType) {
        String contentDispositionFilename;
        if (contentDisposition != null && StringUtils.isNotBlank((CharSequence)(contentDispositionFilename = contentDisposition.getParameter("filename")))) {
            int index;
            String decodedFilename;
            try {
                decodedFilename = MimeUtility.decodeText((String)contentDispositionFilename.trim());
            }
            catch (UnsupportedEncodingException ex) {
                LOG.warn(ex.getMessage());
                decodedFilename = contentDispositionFilename.trim();
            }
            xpMessage.setProcessingDirective("ProcessedOriginalFilename", decodedFilename);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Set processing directive ProcessedOriginalFilename to {}", (Object)decodedFilename);
            }
            if ((index = decodedFilename.indexOf(46)) > -1) {
                return "payload" + decodedFilename.substring(index);
            }
        }
        String fileExtension = DAT;
        if (contentType != null) {
            fileExtension = MimeTypeMapper.getExtension(contentType.getBaseType());
        }
        return "payload" + fileExtension;
    }

    public static Map<String, String> convertMimeHeadersToHashMap(MimeHeaders headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            String[] values = headers.getHeader(header.getName());
            StringBuilder line = new StringBuilder();
            if (values.length == 1) {
                line.append(header.getValue());
            } else {
                for (int i = 0; i < values.length; ++i) {
                    if (i != 0) {
                        line.append(',');
                    }
                    line.append(values[i]);
                }
            }
            String name = header.getName();
            if ("content-type".equalsIgnoreCase(name)) {
                name = "Content-Type";
            }
            result.put(name, line.toString());
        }
        return result;
    }

    public static MimeHeaders convertHashMapToMimeHeaders(Map<String, String> headers) {
        MimeHeaders result = new MimeHeaders();
        Set<String> keys = headers.keySet();
        for (String headerName : keys) {
            String headerValue = headers.get(headerName);
            StringTokenizer values = new StringTokenizer(headerValue, ",");
            while (values.hasMoreTokens()) {
                result.addHeader(headerName, values.nextToken().trim());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createMessageTempFile(MimeMessage message) throws IOException, MessagingException {
        File file;
        File tempFile = null;
        BufferedOutputStream ous = null;
        try {
            tempFile = File.createTempFile("as1_proc", ".mime");
            ous = new BufferedOutputStream(FileUtils.openOutputStream((File)tempFile));
            message.writeTo((OutputStream)ous);
            file = tempFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ous);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)ous);
        return file;
    }
}

