/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;

public class IOUtil {
    public static void closeStreamQuietly(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeZipFileQuietly(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int write(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            return 0;
        }
        if (out == null) {
            return 0;
        }
        byte[] buffer = new byte[8192];
        int size = 0;
        int length = 0;
        while ((length = in.read(buffer)) != -1) {
            size += length;
            out.write(buffer, 0, length);
        }
        return size;
    }

    public static URL getResourceURL(String resourceName, Log log) throws IOException {
        Enumeration<URL> uiConfigs = Thread.currentThread().getContextClassLoader().getResources(resourceName);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (uiConfigs.hasMoreElements()) {
            URL url = uiConfigs.nextElement();
            if (urls.contains(url)) continue;
            urls.add(url);
        }
        switch (urls.size()) {
            case 0: {
                throw new IOException("No resource '" + resourceName + "' found.");
            }
            case 1: {
                break;
            }
            default: {
                if (log == null) break;
                log.warn((Object)("Duplicate resources for '" + resourceName + "' found. The first found resource will be used."));
                for (URL url : urls) {
                    log.warn((Object)("   " + url.toString()));
                }
            }
        }
        return (URL)urls.get(0);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }
}

