/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.util;

import jakarta.mail.Address;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public class EmailUtils {
    private static final String MAILTO = "mailto:";
    private static final String SMIME = "smime:";

    public static final boolean isEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return false;
        }
        boolean result = true;
        try {
            String tempMail = MimeUtility.encodeText((String)email);
            result = EmailUtils.isEmail(new InternetAddress(tempMail));
            return result;
        }
        catch (AddressException | UnsupportedEncodingException e) {
            result = false;
            return false;
        }
    }

    public static final boolean isEmail(InternetAddress email) {
        if (email == null) {
            return false;
        }
        boolean result = true;
        try {
            email.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    public static final URI parseEmailAndGetURI(String destination) throws URISyntaxException {
        if (StringUtils.isBlank((CharSequence)destination)) {
            return null;
        }
        if (destination.startsWith(MAILTO)) {
            String newURI = StringUtils.removeStart((String)destination, (String)MAILTO);
            return new URI(MAILTO + EmailUtils.getEmail(newURI));
        }
        if (destination.startsWith(SMIME)) {
            String newURI = StringUtils.removeStart((String)destination, (String)SMIME);
            return new URI(MAILTO + EmailUtils.getEmail(newURI));
        }
        throw new URISyntaxException(destination, "Could not create uri object.");
    }

    public static final String getEmail(String mail) {
        if (StringUtils.isBlank((CharSequence)mail)) {
            return mail;
        }
        try {
            InternetAddress[] address;
            String tempMail = MimeUtility.encodeText((String)mail);
            for (InternetAddress inet : address = InternetAddress.parse((String)tempMail)) {
                if (!EmailUtils.isEmail(inet)) continue;
                return inet.getAddress();
            }
        }
        catch (AddressException | UnsupportedEncodingException ex) {
            return mail;
        }
        return mail;
    }

    public static final InternetAddress getInternetAdress(String mail) {
        if (StringUtils.isBlank((CharSequence)mail)) {
            return null;
        }
        try {
            InternetAddress[] address;
            String tempMail = MimeUtility.encodeText((String)mail);
            for (InternetAddress inet : address = InternetAddress.parse((String)tempMail)) {
                if (!EmailUtils.isEmail(inet)) continue;
                return inet;
            }
        }
        catch (AddressException | UnsupportedEncodingException ex) {
            return null;
        }
        return null;
    }

    public static final String getMailTO(Address[] adresses) {
        if (adresses == null || adresses.length == 0) {
            throw new IllegalArgumentException("Could not extract any valid email adresses.");
        }
        String result = null;
        for (Address inet : adresses) {
            InternetAddress address = (InternetAddress)inet;
            if (!EmailUtils.isEmail(address)) continue;
            result = MAILTO + address.getAddress();
        }
        if (result == null) {
            throw new IllegalArgumentException("Could not extract any valid email adresses.");
        }
        return result;
    }
}

