/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.uiconfig;

import de.pontonconsulting.xmlpipe.Util;
import de.pontonconsulting.xmlpipe.config.ConfigResourceService;
import de.pontonconsulting.xmlpipe.config.uiconfig.MenuType;
import de.pontonconsulting.xmlpipe.config.uiconfig.OptionType;
import de.pontonconsulting.xmlpipe.config.uiconfig.PackagingType;
import de.pontonconsulting.xmlpipe.config.uiconfig.ProcessingPipelinesType;
import de.pontonconsulting.xmlpipe.uioption.UIOption;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UIConfig {
    private static final String UI_CONFIG_CLASSES = "de.pontonconsulting.xmlpipe.config.uiconfig";
    private static final Log _log = LogFactory.getFactory().getInstance("Messenger.UIConfig");
    private boolean _isLoad = false;
    private de.pontonconsulting.xmlpipe.config.uiconfig.UIConfig _uiConfig;
    private final Map<String, ProcessingPipelinesType.Pipeline> _processingPipelines = new HashMap<String, ProcessingPipelinesType.Pipeline>();
    private final Map<String, OptionType> _pipelineOptions = new HashMap<String, OptionType>();
    private final Map<String, MenuType.MenuItem> _menuItems = new HashMap<String, MenuType.MenuItem>();
    private final Map<String, PackagingType.Package> _packaging = new HashMap<String, PackagingType.Package>();
    private final Map<String, OptionType> _packageOptions = new HashMap<String, OptionType>();

    public UIConfig(String uiConfigPath, ConfigResourceService configResourceService) throws IOException {
        try (InputStream resourceAsStream = configResourceService.getResource(uiConfigPath).getValue();){
            _log.info((Object)("Loading uiconfig: " + uiConfigPath));
            this.readFromStream(resourceAsStream);
            this._isLoad = true;
            _log.info((Object)("UIConfig successfully loaded: " + uiConfigPath));
        }
        catch (JAXBException e) {
            _log.error((Object)("Error while loading of uiconfig: " + String.valueOf((Object)e)));
        }
    }

    public boolean isLoad() {
        return this._isLoad;
    }

    private void readFromStream(InputStream inputStream) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)UI_CONFIG_CLASSES);
        Unmarshaller u = jc.createUnmarshaller();
        ValidationEventCollector vce = new ValidationEventCollector();
        u.setEventHandler((ValidationEventHandler)vce);
        this._uiConfig = (de.pontonconsulting.xmlpipe.config.uiconfig.UIConfig)u.unmarshal(inputStream);
        this.fillCach();
    }

    private void fillCach() {
        this.fillPipelinesCahe();
        this.fillPackagingCahe();
        this.fillMenuItemsCahe();
    }

    private void fillMenuItemsCahe() {
        List menuItems = this._uiConfig.getMenu().getMenuItem();
        for (MenuType.MenuItem menuItem : menuItems) {
            this._menuItems.put(menuItem.getId(), menuItem);
        }
    }

    private void fillPipelinesCahe() {
        List pipelines = this._uiConfig.getProcessingPipelines().getPipeline();
        for (ProcessingPipelinesType.Pipeline pipeline : pipelines) {
            this._processingPipelines.put(pipeline.getId(), pipeline);
            this.fillPipelineOptionsCache(pipeline);
        }
    }

    private void fillPipelineOptionsCache(ProcessingPipelinesType.Pipeline pipeline) {
        List options = pipeline.getOption();
        for (OptionType option : options) {
            String optionName = option.getName();
            String optionPath = "/" + optionName;
            this._pipelineOptions.put(this.getKeyForOptionsCahe(pipeline.getId(), optionPath), option);
            this.fillSuboptionToOptionsCahe(this._pipelineOptions, pipeline.getId(), optionPath, option);
        }
    }

    private void fillSuboptionToOptionsCahe(Map<String, OptionType> cache, String id, String parentOptionPath, OptionType parentOption) {
        List subOptions = parentOption.getOption();
        for (OptionType subOption : subOptions) {
            String optionName = subOption.getName();
            String suboptionPath = parentOptionPath + "/" + optionName;
            cache.put(this.getKeyForOptionsCahe(id, suboptionPath), subOption);
            this.fillSuboptionToOptionsCahe(cache, id, suboptionPath, subOption);
        }
    }

    public List<String> getAllDefinedPipelineIds() {
        return new ArrayList<String>(this._processingPipelines.keySet());
    }

    public List<String> getVisiblePipelineIds() {
        ArrayList<String> visiblePipelineIds = new ArrayList<String>();
        List<String> allIds = this.getAllDefinedPipelineIds();
        for (String pipelineId : allIds) {
            ProcessingPipelinesType.Pipeline pipeline = this.getPipelineConfig(pipelineId);
            if (!pipeline.isVisible()) continue;
            visiblePipelineIds.add(pipelineId);
        }
        return visiblePipelineIds;
    }

    public List<String> getInvisiblePipelineIds() {
        List<String> allIds = this.getAllDefinedPipelineIds();
        allIds.removeAll(this.getVisiblePipelineIds());
        return allIds;
    }

    public boolean isPipelineVisible(String pipelineId) {
        return !this.getInvisiblePipelineIds().contains(pipelineId);
    }

    public ProcessingPipelinesType.Pipeline getPipelineConfig(String id) {
        return this._processingPipelines.get(id);
    }

    public OptionType getPipelineOptionConfig(String pipelineId, String optionPath) {
        return this._pipelineOptions.get(this.getKeyForOptionsCahe(pipelineId, optionPath));
    }

    private void fillPackagingCahe() {
        List packages = this._uiConfig.getPackaging().getPackage();
        for (PackagingType.Package pckg : packages) {
            this._packaging.put(pckg.getId(), pckg);
            this.fillPackageOptionsCache(pckg);
        }
    }

    public OptionType getParentPipelineOptionConfig(String pipelineId, String optionPath) {
        String parentOptionPath = this.determineParentOptionPath(optionPath);
        if (parentOptionPath == null) {
            return null;
        }
        return this.getPipelineOptionConfig(pipelineId, parentOptionPath);
    }

    public OptionType getYoungestAncestorPipelineOptionConfig(String pipelineId, String optionPath) {
        OptionType parent = this.getParentPipelineOptionConfig(pipelineId, optionPath);
        if (parent != null) {
            return parent;
        }
        String parentPath = this.determineParentOptionPath(optionPath);
        if (parentPath == null) {
            return null;
        }
        return this.getYoungestAncestorPipelineOptionConfig(pipelineId, parentPath);
    }

    public boolean isPipelineOptionVisible(String pipelineId, String optionPath) {
        OptionType option = this.getPipelineOptionConfig(pipelineId, optionPath);
        boolean isOptVisible = true;
        if (option != null) {
            isOptVisible = option.isVisible();
        }
        return isOptVisible && this.checkParentPipelineOptions(pipelineId, optionPath);
    }

    public boolean checkParentPipelineOptions(String pipelineId, String optionPath) {
        String[] optNames = optionPath.split("/");
        if (optNames == null || optNames.length < 2) {
            return true;
        }
        Object tempParentPath = "";
        for (int i = 0; i < optNames.length - 1; ++i) {
            String optName = optNames[i];
            tempParentPath = "/" + optName;
            OptionType option = this.getPipelineOptionConfig(pipelineId, (String)tempParentPath);
            if (option == null || option.isVisible()) continue;
            return false;
        }
        return true;
    }

    private void fillPackageOptionsCache(PackagingType.Package pckg) {
        List options = pckg.getOption();
        for (OptionType option : options) {
            String optionName = option.getName();
            String optionPath = "/" + optionName;
            this._packageOptions.put(this.getKeyForOptionsCahe(pckg.getId(), optionPath), option);
            this.fillSuboptionToOptionsCahe(this._packageOptions, pckg.getId(), optionPath, option);
        }
    }

    public List<String> getAllDefinedPackageIds() {
        return new ArrayList<String>(this._packaging.keySet());
    }

    public List<String> getVisiblePackageIds() {
        ArrayList<String> visiblePackageIds = new ArrayList<String>();
        List<String> allIds = this.getAllDefinedPackageIds();
        for (String packageId : allIds) {
            PackagingType.Package pckg = this.getPackageConfig(packageId);
            if (!pckg.isVisible()) continue;
            visiblePackageIds.add(packageId);
        }
        return visiblePackageIds;
    }

    public List<String> getInvisiblePackageIds() {
        List<String> allIds = this.getAllDefinedPackageIds();
        allIds.removeAll(this.getVisiblePackageIds());
        return allIds;
    }

    public boolean isPackageVisible(String pckgId) {
        return !this.getInvisiblePackageIds().contains(pckgId);
    }

    public PackagingType.Package getPackageConfig(String id) {
        return this._packaging.get(id);
    }

    public OptionType getPackageOptionConfig(String packageId, String optionPath) {
        return this._packageOptions.get(this.getKeyForOptionsCahe(packageId, optionPath));
    }

    public OptionType getParentPackageOptionConfig(String packageId, String optionPath) {
        String parentOptionPath = this.determineParentOptionPath(optionPath);
        if (parentOptionPath == null) {
            return null;
        }
        return this.getPackageOptionConfig(packageId, parentOptionPath);
    }

    public OptionType getYoungestAncestorPackageOptionConfig(String packageId, String optionPath) {
        OptionType parent = this.getParentPackageOptionConfig(packageId, optionPath);
        if (parent != null) {
            return parent;
        }
        String parentPath = this.determineParentOptionPath(optionPath);
        if (parentPath == null) {
            return null;
        }
        return this.getYoungestAncestorPackageOptionConfig(packageId, parentPath);
    }

    private String getKeyForOptionsCahe(String id, String optionPath) {
        return id + "_" + optionPath;
    }

    private String determineParentOptionPath(String optionPath) {
        String[] optNames = optionPath.split("/");
        if (optNames == null || optNames.length < 2) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(optNames));
        names.remove(names.size() - 1);
        return "/" + Util.buildString(names, "/");
    }

    public boolean isPackageOptionVisible(String packageId, String optionPath) {
        OptionType option = this.getPackageOptionConfig(packageId, optionPath);
        boolean isOptVisible = true;
        if (option != null) {
            isOptVisible = option.isVisible();
        }
        return isOptVisible && this.checkParentPackageOptions(packageId, optionPath);
    }

    public boolean checkParentPackageOptions(String packageId, String optionPath) {
        String[] optNames = optionPath.split("/");
        if (optNames == null || optNames.length < 2) {
            return true;
        }
        Object tempParentPath = "";
        for (int i = 0; i < optNames.length - 1; ++i) {
            String optName = optNames[i];
            tempParentPath = "/" + optName;
            OptionType option = this.getPackageOptionConfig(packageId, (String)tempParentPath);
            if (option == null || option.isVisible()) continue;
            return false;
        }
        return true;
    }

    public List<UIOption> getVisiblePipelineUIOptions(String pipelineId, UIOption[] uiOptions) {
        ArrayList<UIOption> result = new ArrayList<UIOption>();
        for (int i = 0; i < uiOptions.length; ++i) {
            UIOption uiOption = uiOptions[i];
            if (!this.isPipelineOptionVisible(pipelineId, uiOption.getOptionPath())) continue;
            this.updateUIOption("processing", pipelineId, uiOption);
            result.add(uiOption);
        }
        return result;
    }

    public List<UIOption> getDefaultPipelineUIOptions(String pipelineId, UIOption[] uiOptions) {
        ArrayList<UIOption> result = new ArrayList<UIOption>();
        for (int i = 0; i < uiOptions.length; ++i) {
            UIOption uiOption = uiOptions[i];
            OptionType optionConfig = this.getPipelineOptionConfig(pipelineId, uiOption.getOptionPath());
            if (optionConfig == null || !optionConfig.isActive()) continue;
            this.updateUIOption("processing", pipelineId, uiOption);
            result.add(uiOption);
        }
        return result;
    }

    public List<UIOption> getVisiblePackageUIOptions(String packageId, UIOption[] uiOptions) {
        ArrayList<UIOption> result = new ArrayList<UIOption>();
        for (int i = 0; i < uiOptions.length; ++i) {
            UIOption uiOption = uiOptions[i];
            if (!this.isPackageOptionVisible(packageId, uiOption.getOptionPath())) continue;
            this.updateUIOption("packaging", packageId, uiOption);
            result.add(uiOption);
        }
        return result;
    }

    public List<UIOption> getDefaultPackageUIOptions(String packageId, UIOption[] uiOptions) {
        ArrayList<UIOption> result = new ArrayList<UIOption>();
        for (int i = 0; i < uiOptions.length; ++i) {
            UIOption uiOption = uiOptions[i];
            OptionType optionConfig = this.getPackageOptionConfig(packageId, uiOption.getOptionPath());
            if (optionConfig != null) {
                if (!optionConfig.isActive()) continue;
                this.updateUIOption("packaging", packageId, uiOption);
                result.add(uiOption);
                continue;
            }
            result.add(uiOption);
        }
        return result;
    }

    public void updateUIOptions(String optionSort, String id, UIOption[] uiOptions) {
        for (int i = 0; i < uiOptions.length; ++i) {
            UIOption uiOption = uiOptions[i];
            this.updateUIOption(optionSort, id, uiOption);
        }
    }

    public void updateUIOption(String optionSort, String id, UIOption uiOption) {
        OptionType optionConfig = null;
        this.updateUIOptionVisibilty(optionSort, id, uiOption);
        String optionPath = uiOption.getDefaultOptionPath(optionSort);
        if ("processing".equals(optionSort)) {
            optionConfig = this.getPipelineOptionConfig(id, optionPath);
        } else if ("packaging".equals(optionSort)) {
            optionConfig = this.getPackageOptionConfig(id, optionPath);
        }
        this.updateUIOptionValues(uiOption, optionConfig);
    }

    public void updateUIOptionVisibilty(String optionSort, String id, UIOption uiOption) {
        if (uiOption.getSupported() && uiOption.getUptodate()) {
            if ("processing".equals(optionSort)) {
                uiOption.setVisible(this.isPipelineOptionVisible(id, uiOption.getOptionPath()));
            } else if ("packaging".equals(optionSort)) {
                uiOption.setVisible(this.isPackageOptionVisible(id, uiOption.getOptionPath()));
            }
        }
    }

    private void updateUIOptionValues(UIOption uiOption, OptionType optionConfig) {
        String defaultValue;
        if (optionConfig == null) {
            return;
        }
        String uiConfigValue = optionConfig.getValue();
        if (!Util.isEmpty(uiConfigValue) && uiOption.getActiveOptionValue() != null && "list".equals(uiOption.getType())) {
            String[] uiConfigValues = uiConfigValue.split(",");
            List<String> uiConfigValuesList = new ArrayList<String>(Arrays.asList(uiConfigValues));
            String[] commonValues = uiOption.getCommonValues();
            if (commonValues != null && commonValues.length > 0) {
                ArrayList<String> commonValuesList = new ArrayList<String>(Arrays.asList(commonValues));
                uiConfigValuesList = Util.getIntersect(uiConfigValuesList, commonValuesList);
            }
            uiConfigValuesList.remove(uiOption.getActiveOptionValue());
            uiConfigValuesList.add(uiOption.getActiveOptionValue());
            uiOption.setCommonValues(uiConfigValuesList.toArray(new String[uiConfigValuesList.size()]));
        }
        if (!Util.isEmpty(defaultValue = optionConfig.getDefaultValue())) {
            uiOption.setDefaultValue(defaultValue);
        }
    }

    public String getPreferredPipelineId() {
        Collection<ProcessingPipelinesType.Pipeline> pipelines = this._processingPipelines.values();
        for (ProcessingPipelinesType.Pipeline pipeline : pipelines) {
            if (!pipeline.isVisible() || !pipeline.isPreferred()) continue;
            return pipeline.getId();
        }
        return null;
    }

    public String getPreferredPackageId() {
        Collection<PackagingType.Package> pckgs = this._packaging.values();
        for (PackagingType.Package pckg : pckgs) {
            if (!pckg.isVisible() || !pckg.isPreferred()) continue;
            return pckg.getId();
        }
        return null;
    }

    public boolean isExpertModus(HttpServletRequest request) {
        return request.isUserInRole("ROLE_expert");
    }
}

