/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.soap.ebxml.DateTime;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class MessageData {
    private String _messageId;
    public static final String EBXML_MESSAGE_ID = "MessageId";
    private Date _timestamp;
    public static final String EBXML_TIMESTAMP = "Timestamp";
    private String _refToMessageId;
    public static final String EBXML_REF_TO_MESSAGE_ID = "RefToMessageId";
    private Date _timeToLive;
    public static final String EBXML_TIME_TO_LIVE = "TimeToLive";
    private final ReferenceDateTask referenceDateTask;

    public MessageData(ReferenceDateTask referenceDateTask) {
        this.referenceDateTask = referenceDateTask;
    }

    public MessageData(SOAPElement element, ReferenceDateTask referenceDateTask) throws SOAPException {
        this(referenceDateTask);
        Iterator it = element.getChildElements();
        Name name = null;
        SOAPElement elem = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement)) continue;
            elem = (SOAPElement)subElement;
            name = elem.getElementName();
            if (this.compare(name, EBXML_MESSAGE_ID)) {
                this._messageId = elem.getValue();
                continue;
            }
            if (this.compare(name, EBXML_REF_TO_MESSAGE_ID)) {
                this._refToMessageId = elem.getValue();
                continue;
            }
            if (this.compare(name, EBXML_TIMESTAMP)) {
                String dateValue = elem.getValue();
                if (dateValue == null || dateValue.length() == 0) {
                    throw new SOAPException("Timestamp Element in MessageData is missing");
                }
                try {
                    this._timestamp = DateTime.parseDate(dateValue);
                    continue;
                }
                catch (ParseException e) {
                    throw new SOAPException("Timestamp Element in MessageData has an invalid format:" + String.valueOf(e));
                }
            }
            if (!this.compare(name, EBXML_TIME_TO_LIVE)) continue;
            try {
                this._timeToLive = DateTime.parseDate(elem.getValue());
            }
            catch (ParseException e) {
                throw new SOAPException("TimeToLive Element in MessageData has an invalid format:" + String.valueOf(e));
            }
        }
    }

    public String getMessageId() {
        return this._messageId;
    }

    public void setMessageId(String messageId) {
        this._messageId = messageId;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this._timestamp = timestamp;
    }

    public String getRefToMessageId() {
        return this._refToMessageId;
    }

    public void setRefToMessageId(String refToMessageId) {
        this._refToMessageId = refToMessageId;
    }

    public Date getTimeToLive() {
        return this._timeToLive;
    }

    public void setTimeToLive(Date timeToLive) {
        this._timeToLive = timeToLive;
    }

    protected final boolean compare(Name got, String localName) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase("http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
    }

    public void generateSOAP(SOAPElement element, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        name = envelope.createName(EBXML_MESSAGE_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebMessageId = element.addChildElement(name);
        ebMessageId.addTextNode(this._messageId);
        name = envelope.createName(EBXML_TIMESTAMP, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebTimestamp = element.addChildElement(name);
        ebTimestamp.addTextNode(DateTime.formatDate(this._timestamp));
        if (this._refToMessageId != null) {
            name = envelope.createName(EBXML_REF_TO_MESSAGE_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebRefId = element.addChildElement(name);
            ebRefId.addTextNode(this._refToMessageId);
        }
        if (this._timeToLive != null) {
            name = envelope.createName(EBXML_TIME_TO_LIVE, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebTTL = element.addChildElement(name);
            ebTTL.addTextNode(DateTime.formatDate(this._timeToLive));
        }
    }

    public void validate() throws EbXmlException {
        Date now;
        if (this._messageId == null) {
            throw new EbXmlException(30031, "Error", "OtherXml", "MessageId Element is required in MessageData.");
        }
        if (this._timestamp == null) {
            throw new EbXmlException(30032, "Error", "OtherXml", "Timestamp Element is required in MessageData.");
        }
        if (this._timeToLive != null && (now = this.referenceDateTask.getReferenceDate()).after(this.getTimeToLive())) {
            String ttl = DateTime.formatDate(this.getTimeToLive());
            throw new EbXmlException(30033, new String[]{DateTime.formatDate(now), ttl}, "Error", "TimeToLiveExpired", "Message was not received in time. localtime:" + DateTime.formatDate(now) + "  Time To Live:" + ttl);
        }
    }
}

