/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.security.xmlsig.ApacheSigner;
import de.pontonconsulting.xmlpipe.security.xmlsig.SignException;
import de.pontonconsulting.xmlpipe.security.xmlsig.VerifyException;
import de.pontonconsulting.xmlpipe.soap.ebxml.AttachmentInfo;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.HeaderExtension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DigitalSignatureReference
extends HeaderExtension {
    private static final String CONTENT_ID_PREFIX = "cid:";
    private static final String SIGNATURE_ELEMENT = "Signature";
    private static final String HEADER_ELEMENT = "Header";
    public static final String EBXML_ACTOR = "Actor";
    public static final String EBXML_ACTOR_NEXT_MSH = "urn:oasis:names:tc:ebxml-msg:actor:nextMSH";
    public static final String EBXML_ACTOR_TO_PARTY_MSH = "urn:oasis:names:tc:ebxml-msg:actor:toPartyMSH";
    protected static final String DSIG_URI = "http://www.w3.org/2000/09/xmldsig#";
    private SOAPMessage _soapMessage;
    private PrivateKey _privateKey;
    private Certificate[] _certificateChain;
    private ApacheSigner _signature;
    private List<SOAPElement> _references;

    public DigitalSignatureReference(SOAPMessage sp, PrivateKey privateKey, Certificate[] certificateChain) {
        this._soapMessage = sp;
        this._privateKey = privateKey;
        this._certificateChain = certificateChain;
    }

    public DigitalSignatureReference(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Name name = env.createName("SignedInfo", "ds", DSIG_URI);
        Name referencesName = env.createName("Reference", "ds", DSIG_URI);
        ArrayList<SOAPElement> r = new ArrayList<SOAPElement>();
        Iterator it = elem.getChildElements(name);
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement)) continue;
            SOAPElement signedInfo = (SOAPElement)subElement;
            Iterator refs = signedInfo.getChildElements(referencesName);
            while (refs.hasNext()) {
                subElement = refs.next();
                if (!(subElement instanceof SOAPElement)) continue;
                SOAPElement reference = (SOAPElement)subElement;
                r.add(reference);
            }
        }
        this._references = r;
    }

    public boolean verifySignature(File ebXmlMessageFile, Iterator<AttachmentInfo> attachments, PublicKey publicKey) throws ParserConfigurationException, SAXException, SignException, VerifyException, IOException, SOAPException {
        this._signature = new ApacheSigner();
        Document doc = this.parseEnvelope(ebXmlMessageFile);
        while (attachments.hasNext()) {
            AttachmentInfo element = attachments.next();
            String contentId = element.getContentId();
            if (contentId.startsWith("<")) {
                contentId = contentId.replace('<', ' ').replace('>', ' ').trim();
            }
            this._signature.addDocument(CONTENT_ID_PREFIX + contentId, element.getInputStream(), element.getContentType());
        }
        this._signature.setEnvelope(doc);
        return this._signature.verify(publicKey);
    }

    private Document parseEnvelope(File ebXmlMessageFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(ebXmlMessageFile);
        return doc;
    }

    public List<SOAPElement> getSignatureReferences() {
        return this._references;
    }

    public Certificate extractSenderCertificate(File ebXmlMessageFile) throws ParserConfigurationException, SAXException, IOException, SignException, VerifyException {
        ApacheSigner signature = new ApacheSigner();
        Document doc = this.parseEnvelope(ebXmlMessageFile);
        signature.setEnvelope(doc);
        return signature.extractSenderCertificate();
    }

    public void generateSOAP() throws SignException, SOAPException {
        ByteArrayInputStream soapInput;
        ArrayList<AttachmentPart> attachments = new ArrayList<AttachmentPart>();
        Iterator iter = this._soapMessage.getAttachments();
        while (iter.hasNext()) {
            attachments.add((AttachmentPart)iter.next());
        }
        this._soapMessage.removeAllAttachments();
        if (this._soapMessage.saveRequired()) {
            this._soapMessage.saveChanges();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this._soapMessage.writeTo((OutputStream)baos);
            baos.close();
            soapInput = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception e) {
            SignException se = new SignException(28008, "Problem while preparing SoapMessage:" + e.toString());
            se.setStackTrace(e.getStackTrace());
            throw se;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        dbf.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(soapInput);
        }
        catch (Throwable ex) {
            SignException se = new SignException(28009, "Problem while parsing SoapMessage:" + ex.toString());
            se.setStackTrace(ex.getStackTrace());
            throw se;
        }
        finally {
            try {
                soapInput.close();
            }
            catch (Exception db) {}
        }
        Node header = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", HEADER_ELEMENT).item(0);
        ApacheSigner signature = new ApacheSigner();
        signature.setEnvelope(doc, "rsa-sha1");
        header.appendChild(signature.getElement());
        for (int i = 0; i < attachments.size(); ++i) {
            AttachmentPart temp = (AttachmentPart)attachments.get(i);
            try {
                String contentIdFix = temp.getContentId();
                contentIdFix = contentIdFix.replace('<', ' ');
                contentIdFix = contentIdFix.replace('>', ' ');
                signature.addDocument(CONTENT_ID_PREFIX + contentIdFix.trim(), temp.getDataHandler().getInputStream(), temp.getContentType());
                continue;
            }
            catch (Exception e) {
                SignException se = new SignException(28010, "Problem while preparing Attachments:" + e.toString());
                se.setStackTrace(e.getStackTrace());
                throw se;
            }
        }
        signature.sign(this._privateKey, this._certificateChain);
        Node xmlsig = doc.getElementsByTagNameNS(DSIG_URI, SIGNATURE_ELEMENT).item(0);
        if (this._soapMessage.saveRequired()) {
            this._soapMessage.saveChanges();
        }
        this.addToSOAPHeader(this._soapMessage.getSOAPPart().getEnvelope(), xmlsig);
        for (int i = 0; i < attachments.size(); ++i) {
            AttachmentPart temp = (AttachmentPart)attachments.get(i);
            this._soapMessage.addAttachmentPart(temp);
        }
        this._soapMessage.saveChanges();
    }

    private void addToSOAPHeader(SOAPEnvelope env, Node node) throws SOAPException {
        if (node.getNodeType() != 1) {
            throw new SOAPException("DOMNode must of type ELEMENT_NODE");
        }
        SOAPFactory sf = SOAPFactory.newInstance();
        SOAPHeaderElement se = env.getHeader().addHeaderElement(sf.createName(node.getLocalName(), node.getPrefix(), node.getNamespaceURI()));
        if (node.hasAttributes()) {
            NamedNodeMap DOMAttributes = node.getAttributes();
            int noOfAttributes = DOMAttributes.getLength();
            for (int i = 0; i < noOfAttributes; ++i) {
                Node attribute = DOMAttributes.item(i);
                String name = attribute.getLocalName();
                String uri = attribute.getNamespaceURI();
                String value = attribute.getNodeValue();
                if (uri != null || name == null) continue;
                se.addAttribute(env.createName(name), value);
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            block6: for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                switch (child.getNodeType()) {
                    case 7: {
                        continue block6;
                    }
                    case 10: {
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 8: {
                        se.addTextNode(child.getNodeValue());
                        continue block6;
                    }
                    default: {
                        se.addChildElement(this.convertDOMToSOAPElement(env, child));
                    }
                }
            }
        }
    }

    private SOAPElement convertDOMToSOAPElement(SOAPEnvelope env, Node node) throws SOAPException {
        if (node.getNodeType() != 1) {
            throw new SOAPException("DOMNode must of type ELEMENT_NODE");
        }
        SOAPFactory sf = SOAPFactory.newInstance();
        SOAPElement se = sf.createElement(node.getLocalName(), node.getPrefix(), node.getNamespaceURI());
        if (node.hasAttributes()) {
            NamedNodeMap DOMAttributes = node.getAttributes();
            int noOfAttributes = DOMAttributes.getLength();
            for (int i = 0; i < noOfAttributes; ++i) {
                Node attribute = DOMAttributes.item(i);
                String name = attribute.getLocalName();
                String uri = attribute.getNamespaceURI();
                String value = attribute.getNodeValue();
                if (uri != null || name == null) continue;
                se.addAttribute(env.createName(name), value);
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            block6: for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                switch (child.getNodeType()) {
                    case 7: {
                        continue block6;
                    }
                    case 10: {
                        continue block6;
                    }
                    case 3: 
                    case 4: 
                    case 8: {
                        se.addTextNode(child.getNodeValue());
                        continue block6;
                    }
                    default: {
                        se.addChildElement(this.convertDOMToSOAPElement(env, child));
                    }
                }
            }
        }
        return se;
    }
}

