/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.header;

import de.pontonconsulting.xmlpipe.soap.ebxml.DateTime;
import de.pontonconsulting.xmlpipe.soap.ebxml.EbXmlException;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.DigitalSignatureReference;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.HeaderExtension;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Party;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;

public class Acknowledgment
extends HeaderExtension {
    private Date _timestamp;
    public static final String EBXML_TIMESTAMP = "Timestamp";
    private String _refToMessageId;
    public static final String EBXML_REFTO_MESSAGE_ID = "RefToMessageId";
    private String _actor;
    public static final String EBXML_ACTOR = "Actor";
    public static final String EBXML_ACTOR_NEXT_MSH = "urn:oasis:names:tc:ebxml-msg:actor:nextMSH";
    public static final String EBXML_ACTOR_TO_PARTY_MSH = "urn:oasis:names:tc:ebxml-msg:actor:toPartyMSH";
    private Party _from;
    public static final String EBXML_FROM = "From";
    private final Collection<DigitalSignatureReference> _digitalSignatureReference = new ArrayList<DigitalSignatureReference>();
    private List<SOAPElement> _signatureReferences;

    public Acknowledgment(Date timestamp, String refToMessageId, List<SOAPElement> signatureReferences) {
        this._timestamp = timestamp;
        this._refToMessageId = refToMessageId;
        this._signatureReferences = signatureReferences;
    }

    public Acknowledgment(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        super(elem, env);
        Name name = env.createName(EBXML_ACTOR, "soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
        this._actor = elem.getAttributeValue(name);
        Iterator it = elem.getChildElements();
        SOAPElement element = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement)) continue;
            element = (SOAPElement)subElement;
            name = element.getElementName();
            if (this.compare(name, EBXML_TIMESTAMP)) {
                try {
                    this._timestamp = DateTime.parseDate(element.getValue());
                    continue;
                }
                catch (ParseException e) {
                    throw new SOAPException("Timestamp Element in Acknowledgement has an invalid format:" + String.valueOf(e));
                }
            }
            if (this.compare(name, EBXML_REFTO_MESSAGE_ID)) {
                this._refToMessageId = element.getValue();
                continue;
            }
            if (!this.compare(name, EBXML_FROM)) continue;
            this._from = new Party(elem, env);
        }
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this._timestamp = timestamp;
    }

    public String getRefToMessageId() {
        return this._refToMessageId;
    }

    public void setRefToMessageId(String refToMessageId) {
        this._refToMessageId = refToMessageId;
    }

    public String getActor() {
        if (this._actor == null) {
            return EBXML_ACTOR_TO_PARTY_MSH;
        }
        return this._actor;
    }

    public void setActor(String actor) {
        this._actor = actor;
    }

    public Party getFrom() {
        return this._from;
    }

    public void setFrom(Party from) {
        this._from = from;
    }

    public void addFromPartyId(String partyId, String partyIdType) {
        if (this._from == null) {
            this._from = new Party();
        }
        this._from.addPartyId(partyId, partyIdType);
    }

    public Collection<DigitalSignatureReference> getDigitalSignatureReferences() {
        return this._digitalSignatureReference;
    }

    public void addDigitalSignatureReference(DigitalSignatureReference digitalSignatureReference) {
        if (!this._digitalSignatureReference.contains(digitalSignatureReference)) {
            this._digitalSignatureReference.add(digitalSignatureReference);
        }
    }

    public void removeDigitalSignatureReference(DigitalSignatureReference digitalSignatureReference) {
        this._digitalSignatureReference.remove(digitalSignatureReference);
    }

    public void generateSOAP(SOAPHeaderElement ebHeader, SOAPEnvelope envelope) throws SOAPException {
        Name name = null;
        this.generateMustUnderstand(ebHeader, envelope);
        if (this.getId() != null) {
            name = envelope.createName("id", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            ebHeader.addAttribute(name, this.getId());
        }
        name = envelope.createName("version", "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        ebHeader.addAttribute(name, this.getVersion());
        if (this._actor != null) {
            name = envelope.createName(EBXML_ACTOR, "soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
            ebHeader.addAttribute(name, this._actor);
        }
        name = envelope.createName(EBXML_TIMESTAMP, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebTimestamp = ebHeader.addChildElement(name);
        ebTimestamp.addTextNode(DateTime.formatDate(this._timestamp));
        name = envelope.createName(EBXML_REFTO_MESSAGE_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        SOAPElement ebRefTo = ebHeader.addChildElement(name);
        ebRefTo.addTextNode(this._refToMessageId);
        if (this._from != null) {
            name = envelope.createName(EBXML_FROM, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebFrom = ebHeader.addChildElement(name);
            this._from.generateSOAP(ebFrom, envelope);
        }
        if (this._signatureReferences != null) {
            for (SOAPElement reference : this._signatureReferences) {
                ebHeader.addChildElement(reference);
            }
        }
    }

    public void validate() throws EbXmlException {
        if (this._timestamp == null) {
            throw new EbXmlException(30026, "Error", "OtherXml", "Timestamp missing in Acknowledgement");
        }
        if (this._refToMessageId == null) {
            throw new EbXmlException(30027, "Error", "OtherXml", "RefToMessageId missing in Acknowledgement");
        }
        if (this._actor != null && !this._actor.equals(EBXML_ACTOR_NEXT_MSH) && !this._actor.equals(EBXML_ACTOR_TO_PARTY_MSH)) {
            throw new EbXmlException(30028, "Error", "OtherXml", "Unknown Actor in Acknowledgement");
        }
    }
}

