/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.soap.ebxml.body;

import de.pontonconsulting.xmlpipe.soap.ebxml.body.Schema;
import de.pontonconsulting.xmlpipe.soap.ebxml.header.Description;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;

public class Reference {
    private String _id;
    public static final String EBXML_ID = "id";
    private final String _xlinkHref;
    public static final String EBXML_XLINK_HREF = "href";
    private final String _xlinkRole;
    public static final String EBXML_XLINK_ROLE = "role";
    private String _xlinkType;
    public static final String EBXML_XLINK_TYPE = "type";
    private final Collection<Schema> _schema = new ArrayList<Schema>();
    public static final String EBXML_SCHEMA = "Schema";
    private final Collection<Description> _description = new ArrayList<Description>();
    public static final String EBXML_DESCRIPTION = "Description";

    public Reference(String href, String role, String type) {
        this._xlinkHref = href;
        this._xlinkRole = role;
        this._xlinkType = type;
    }

    public Reference(SOAPElement elem, SOAPEnvelope env) throws SOAPException {
        Name name = env.createName(EBXML_XLINK_HREF, "xlink", "http://www.w3.org/1999/xlink");
        this._xlinkHref = elem.getAttributeValue(name);
        name = env.createName(EBXML_XLINK_ROLE, "xlink", "http://www.w3.org/1999/xlink");
        this._xlinkRole = elem.getAttributeValue(name);
        name = env.createName(EBXML_ID, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
        this._id = elem.getAttributeValue(name);
        Iterator it = elem.getChildElements();
        SOAPElement element = null;
        while (it.hasNext()) {
            Object subElement = it.next();
            if (!(subElement instanceof SOAPElement)) continue;
            element = (SOAPElement)subElement;
            name = element.getElementName();
            if (this.compare(name, EBXML_SCHEMA)) {
                this._schema.add(new Schema(element, env));
                continue;
            }
            if (!this.compare(name, EBXML_DESCRIPTION)) continue;
            this._description.add(new Description(element, env));
        }
    }

    public Collection<Schema> getSchemas() {
        return this._schema;
    }

    public void addSchema(Schema schema) {
        if (!this._schema.contains(schema)) {
            this._schema.add(schema);
        }
    }

    public void addSchema(String location, String version) {
        this._schema.add(new Schema(location, version));
    }

    public void removeSchema(Schema schema) {
        this._schema.remove(schema);
    }

    public Collection<Description> getDescriptions() {
        return this._description;
    }

    public void addDescription(Description description) {
        if (!this._description.contains(description)) {
            this._description.add(description);
        }
    }

    public void addDescription(String text, String language) {
        this._description.add(new Description(text, language));
    }

    public void removeDescription(Description description) {
        this._description.remove(description);
    }

    protected final boolean compare(Name got, String localName) {
        return got.getLocalName().equalsIgnoreCase(localName) && got.getURI().equalsIgnoreCase("http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
    }

    public void generateSOAP(SOAPElement ebBody, SOAPEnvelope envelope) throws SOAPException {
        Object element;
        Name name = null;
        if (this._id != null) {
            name = envelope.createName(EBXML_ID);
            ebBody.addAttribute(name, this._id);
        }
        name = envelope.createName(EBXML_XLINK_HREF, "xlink", "http://www.w3.org/1999/xlink");
        ebBody.addAttribute(name, this._xlinkHref);
        if (this._xlinkRole != null && this._xlinkRole.length() > 0) {
            name = envelope.createName(EBXML_XLINK_ROLE, "xlink", "http://www.w3.org/1999/xlink");
            ebBody.addAttribute(name, this._xlinkRole);
        }
        if (this._xlinkType != null) {
            name = envelope.createName(EBXML_XLINK_TYPE, "xlink", "http://www.w3.org/1999/xlink");
            ebBody.addAttribute(name, this._xlinkType);
        }
        Iterator<Object> i = this._schema.iterator();
        while (i.hasNext()) {
            name = envelope.createName(EBXML_SCHEMA, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebSchema = ebBody.addChildElement(name);
            element = (Schema)i.next();
            ((Schema)element).generateSOAP(ebSchema, envelope);
        }
        i = this._description.iterator();
        while (i.hasNext()) {
            name = envelope.createName(EBXML_DESCRIPTION, "eb", "http://www.oasis-open.org/committees/ebxml-msg/schema/msg-header-2_0.xsd");
            SOAPElement ebDescription = ebBody.addChildElement(name);
            element = (Description)i.next();
            ((Description)element).generateSOAP(ebDescription, envelope);
        }
    }

    public String getXlinkHref() {
        return this._xlinkHref;
    }

    public String getXlinkRole() {
        return this._xlinkRole;
    }
}

