/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.server;

import de.ponton.api.websocket.ApiWebSocketServer;
import de.ponton.xmlpipe.bootstrap.ResultCode;
import de.ponton.xmlpipe.notification.CertificateExpirationNotificationService;
import de.ponton.xmlpipe.queue.InboundQueue;
import de.ponton.xmlpipe.queue.OutboundQueueConsumer;
import de.ponton.xmlpipe.queue.QueueMessageConsumer;
import de.ponton.xmlpipe.websocket.WebsocketClient;
import de.pontonconsulting.common.file.DBConfigChangeWatcher;
import de.pontonconsulting.xmlpipe.Constants;
import de.pontonconsulting.xmlpipe.adapter.AdapterLauncher;
import de.pontonconsulting.xmlpipe.adapter.as4certificateupdate.AS4TestService;
import de.pontonconsulting.xmlpipe.cluster.GlobalTaskManager;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.config.ServerSettings;
import de.pontonconsulting.xmlpipe.config.SslContextFactoryInitializer;
import de.pontonconsulting.xmlpipe.events.EnterMaintenanceModeEvent;
import de.pontonconsulting.xmlpipe.events.RegisterServiceProvider;
import de.pontonconsulting.xmlpipe.events.ServiceLevel;
import de.pontonconsulting.xmlpipe.events.ServiceStatus;
import de.pontonconsulting.xmlpipe.events.ShutdownCompleted;
import de.pontonconsulting.xmlpipe.events.ShutdownService;
import de.pontonconsulting.xmlpipe.events.StartupCompleted;
import de.pontonconsulting.xmlpipe.events.StartupFailed;
import de.pontonconsulting.xmlpipe.events.StartupService;
import de.pontonconsulting.xmlpipe.listener.ListenerDispatcherServlet;
import de.pontonconsulting.xmlpipe.listener.ListenerManager;
import de.pontonconsulting.xmlpipe.messenger.IServiceProvider;
import de.pontonconsulting.xmlpipe.messenger.MaintenanceManager;
import de.pontonconsulting.xmlpipe.messenger.adapter.AdapterDispatcherServlet;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.HttpAdapterInfo;
import de.pontonconsulting.xmlpipe.messenger.database.tables.HttpAdapterInfoDAO;
import de.pontonconsulting.xmlpipe.server.PontonErrorPageHandler;
import de.pontonconsulting.xmlpipe.server.Services;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.runtime.SwitchBootstraps;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee10.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee10.webapp.Configurations;
import org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class Server
implements ApplicationListener<ApplicationEvent> {
    private static final String DEFAULT_WEB_CONTEXT = "/pontonxp";
    private static final String DEFAULT_REST_WEB_CONTEXT = "";
    private static final String PROPERTY_WEB_CONTEXT_ADAPTER = "ponton.web.context.adapter";
    private static final String PROPERTY_WEB_CONTEXT_REST = "ponton.web.context.rest";
    private static final String PROPERTY_WEB_CONTEXT_LISTENER = "ponton.web.context.listener";
    private static final String PROPERTY_WEB_CONTEXT_GUI = "ponton.web.context.gui";
    private static final Log LOG = LogFactory.getLog((String)"Messenger.Server");
    private ResultCode _resultCode;
    private ShutdownHook _shutdownHook;
    private final IServerConfigBean _config;
    private final ListenerManager _listenerManager;
    private final IMessengerProperties _messengerProperties;
    private final ListenerDispatcherServlet listenerDispatcherServlet;
    private final AdapterDispatcherServlet adapterDispatcherServlet;
    private final AdapterLauncher adapterLauncher;
    private final ApiWebSocketServer apiWebSocketServer;
    private final OutboundQueueConsumer outboundQueueConsumer;
    private final InboundQueue inboundMessageQueue;
    private final QueueMessageConsumer inboundQueueMessageConsumer;
    private final HttpAdapterInfoDAO httpAdapterInfoDAO;
    private final GlobalTaskManager globalTaskManager;
    private final AS4TestService as4TestService;
    private final CertificateExpirationNotificationService certificateExpirationNotificationService;
    private final List<DBConfigChangeWatcher> configChangeWatchers;
    private List<String> _restServers;
    private List<String> _httpAdapters;
    private List<org.eclipse.jetty.server.Server> _servers;
    private String restPortSuffix = "";
    private final Object _activeServer = new Object();
    private final ApplicationContext _context;
    private final HashMap<ServiceLevel, HashMap<IServiceProvider, ServiceStatus>> _serviceProviders;
    private final SslContextFactoryInitializer sslContextFactoryInitializer;
    private boolean startupComplete;

    public Server(IServerConfigBean config, ListenerManager listenerManager, IMessengerProperties messengerProperties, ListenerDispatcherServlet listenerDispatcherServlet, AdapterDispatcherServlet adapterDispatcherServlet, AdapterLauncher adapterLauncher, ApiWebSocketServer apiWebSocketServer, InboundQueue inboundMessageQueue, OutboundQueueConsumer outboundQueueConsumer, QueueMessageConsumer inboundQueueMessageConsumer, HttpAdapterInfoDAO httpAdapterInfoDAO, AS4TestService as4TestService, CertificateExpirationNotificationService certificateExpirationNotificationService, DBConfigChangeWatcher messengerConfigChangeWatcher, DBConfigChangeWatcher schemataChangeWatcher, DBConfigChangeWatcher envelopesChangeWatcher, DBConfigChangeWatcher agreementTemplateConfigWatcher, DBConfigChangeWatcher hotfolderConfigWatcher, ApplicationContext context, SslContextFactoryInitializer sslContextFactoryInitializer, GlobalTaskManager globalTaskManager) {
        this._config = config;
        this._listenerManager = listenerManager;
        this._messengerProperties = messengerProperties;
        this.listenerDispatcherServlet = listenerDispatcherServlet;
        this.adapterDispatcherServlet = adapterDispatcherServlet;
        this.adapterLauncher = adapterLauncher;
        this.apiWebSocketServer = apiWebSocketServer;
        this.inboundMessageQueue = inboundMessageQueue;
        this.outboundQueueConsumer = outboundQueueConsumer;
        this.inboundQueueMessageConsumer = inboundQueueMessageConsumer;
        this.httpAdapterInfoDAO = httpAdapterInfoDAO;
        this.as4TestService = as4TestService;
        this.certificateExpirationNotificationService = certificateExpirationNotificationService;
        this.configChangeWatchers = List.of(messengerConfigChangeWatcher, schemataChangeWatcher, envelopesChangeWatcher, agreementTemplateConfigWatcher, hotfolderConfigWatcher);
        this._context = context;
        this.sslContextFactoryInitializer = sslContextFactoryInitializer;
        this._serviceProviders = new HashMap();
        this.startupComplete = false;
        this.globalTaskManager = globalTaskManager;
        for (ServiceLevel serviceLevel : ServiceLevel.SERVICE_LEVELS) {
            this._serviceProviders.put(serviceLevel, new HashMap());
        }
    }

    private void logSystemProperties() {
        new TreeMap<Object, Object>(System.getProperties()).forEach((key, value) -> {
            String escapedValue;
            if ("line.separator".equals(key)) {
                escapedValue = switch (String.valueOf(value)) {
                    case "\r" -> "CR";
                    case "\n" -> "LF";
                    case "\r\n" -> "CRLF";
                    default -> String.valueOf(value);
                };
            } else {
                escapedValue = String.valueOf(value);
            }
            LOG.trace((Object)("SystemProperty: " + String.valueOf(key) + " = " + escapedValue));
        });
    }

    private void startup() throws Exception {
        this.setJaxpProperties();
        this.logSystemProperties();
        this.startMessenger();
        this.as4TestService.start();
        this.certificateExpirationNotificationService.start();
        this.configChangeWatchers.forEach(DBConfigChangeWatcher::startWatcher);
        this.inboundMessageQueue.init();
        this.globalTaskManager.init();
        this.startServers();
        if (this._config.isAdapterInterfaceEnabled()) {
            this.apiWebSocketServer.startup();
        } else {
            LOG.warn((Object)"Adapter interface for Adapter API 2.0 is disabled.");
        }
        this.adapterLauncher.startAdapters();
        this.startOutboundQueueConsumerThread();
        this.startInboundQueueConsumerThread();
        System.out.println("*********************************************************************\n");
        System.out.println("    Ponton X/P Messenger V" + Constants.getXP_VERSION() + " is initialized.\n");
        System.out.println("    (C) 2000-" + Calendar.getInstance().get(1) + " PONTON GmbH\n");
        System.out.println("    The AdminTool is available on" + this.restPortSuffix + ":");
        for (String connection : this._restServers) {
            System.out.println("      " + connection + this.getRestContext() + "\n");
        }
        if (!this._restServers.isEmpty()) {
            System.out.println("    The REST API is available on" + this.restPortSuffix + ":");
            for (String connection : this._restServers) {
                System.out.println("      " + connection + this.getRestContext() + "/api/swagger-ui\n");
            }
        }
        if (!this._httpAdapters.isEmpty()) {
            System.out.println("    The HTTP Adapters are available on:");
            for (String connection : this._httpAdapters) {
                System.out.println("      " + connection + "/httpadapter\n");
            }
        }
        System.out.println("*********************************************************************");
        LOG.info((Object)"***** Startup completed *****");
        this.startupComplete = true;
    }

    private void startInboundQueueConsumerThread() {
        Thread inboundQueueConsumerThread = new Thread(this.inboundQueueMessageConsumer);
        inboundQueueConsumerThread.setName("InboundQueueConsumer");
        inboundQueueConsumerThread.setDaemon(true);
        inboundQueueConsumerThread.setPriority(9);
        inboundQueueConsumerThread.start();
    }

    private void startOutboundQueueConsumerThread() {
        Thread outboundQueueConsumerThread = new Thread(this.outboundQueueConsumer);
        outboundQueueConsumerThread.setName("OutboundQueueConsumer");
        outboundQueueConsumerThread.setDaemon(true);
        outboundQueueConsumerThread.setPriority(9);
        outboundQueueConsumerThread.start();
    }

    private void setJaxpProperties() {
        List<String> jaxpProperties = List.of("jdk.xml.entityExpansionLimit", "jdk.xml.elementAttributeLimit", "jdk.xml.maxOccurLimit", "jdk.xml.totalEntitySizeLimit", "jdk.xml.maxGeneralEntitySizeLimit", "jdk.xml.maxParameterEntitySizeLimit", "jdk.xml.entityReplacementLimit", "jdk.xml.maxElementDepth", "jdk.xml.maxXMLNameLimit", "jdk.xml.isStandalone", "jdk.xml.xsltcIsStandalone", "jdk.xml.cdataChunkSize", "jdk.xml.xpathExprGrpLimit", "jdk.xml.xpathExprOpLimit", "jdk.xml.xpathTotalOpLimit");
        for (String jaxpProperty : jaxpProperties) {
            String value = this._messengerProperties.getProperty(jaxpProperty);
            if (value == null) continue;
            System.setProperty(jaxpProperty, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean removeHook) throws Exception {
        System.out.println("Going to stop Ponton X/P");
        LOG.info((Object)"**** Going to stop Ponton X/P ****");
        this.configChangeWatchers.forEach(DBConfigChangeWatcher::stopWatcher);
        this.certificateExpirationNotificationService.stop();
        this.as4TestService.stop();
        this.outboundQueueConsumer.close();
        this.inboundQueueMessageConsumer.shutdown();
        this.inboundMessageQueue.shutdown();
        if (removeHook) {
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.apiWebSocketServer.shutdown();
        this.adapterLauncher.stopAdapters();
        this.globalTaskManager.shutdown();
        this.stopWebsocketClient();
        this.stopMessenger();
        this.stopServers();
        ((AbstractApplicationContext)this._context).close();
        System.out.println("\n*********************************************************************\n");
        System.out.println("    Ponton X/P Messenger V" + Constants.getXP_VERSION() + " is stopped.\n");
        System.out.println("    (C) 2000-" + Calendar.getInstance().get(1) + " Ponton GmbH");
        System.out.println();
        System.out.println("*********************************************************************");
        Server server = this;
        synchronized (server) {
            this.notify();
        }
    }

    private void stopWebsocketClient() {
        WebsocketClient websocket = (WebsocketClient)this._context.getBean(WebsocketClient.class);
        websocket.shutdown();
        LOG.info((Object)"Websocket connection stopped");
    }

    private void loadREST(org.eclipse.jetty.server.Server server, int port) {
        LOG.debug((Object)"Loading REST API Context");
        String webappPath = new File("gui").getPath();
        WebAppContext jettyWebapp = new WebAppContext();
        jettyWebapp.setContextPath(this.getRestContext());
        jettyWebapp.setWar(webappPath);
        jettyWebapp.setDescriptor(Server.class.getResource("/rest/WEB-INF/rest-web.xml").toString());
        jettyWebapp.setExtractWAR(true);
        jettyWebapp.setErrorHandler((Request.Handler)new PontonErrorPageHandler());
        jettyWebapp.setTempDirectory(new File(this._config.getTempFolder()));
        jettyWebapp.getSessionHandler().setHttpOnly(true);
        jettyWebapp.getSessionHandler().setSecureRequestOnly(true);
        jettyWebapp.getSessionHandler().setSessionCookie("SESSIONID" + port);
        jettyWebapp.setThrowUnavailableOnStartupException(true);
        jettyWebapp.setInitParameter("dirAllowed", "false");
        XmlWebApplicationContext springXmlWebApplicationContext = new XmlWebApplicationContext(this){

            protected void initBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
                xmlBeanDefinitionReader.setValidating(false);
            }
        };
        springXmlWebApplicationContext.setConfigLocations(new String[]{"classpath:/rest/WEB-INF/rest.xml"});
        springXmlWebApplicationContext.setParent(this._context);
        jettyWebapp.addEventListener((EventListener)new ContextLoaderListener((WebApplicationContext)springXmlWebApplicationContext));
        jettyWebapp.addEventListener((EventListener)new HttpSessionEventPublisher());
        Configurations classlist = Configurations.setServerDefault((org.eclipse.jetty.server.Server)server);
        classlist.add(new String[]{JettyWebXmlConfiguration.class.getName(), AnnotationConfiguration.class.getName()});
        ContextHandlerCollection handlerList = new ContextHandlerCollection(new ContextHandler[0]);
        handlerList.addHandler((Handler)jettyWebapp);
        server.setHandler(this.wrapWithSecurityHandler((Handler)handlerList));
        server.setErrorHandler((Request.Handler)new PontonErrorPageHandler());
        LOG.info((Object)"REST API loaded.");
    }

    private void loadHTTPAdapter(org.eclipse.jetty.server.Server server, int port) {
        LOG.debug((Object)"Loading HTTP Adapter Context");
        String webappPath = new File("httpadapter").getPath();
        WebAppContext jettyWebapp = new WebAppContext();
        jettyWebapp.setContextPath("/");
        jettyWebapp.setWar(webappPath);
        jettyWebapp.setDescriptor(webappPath + "/WEB-INF/adapter-web.xml");
        jettyWebapp.setExtractWAR(true);
        jettyWebapp.setErrorHandler((Request.Handler)new PontonErrorPageHandler());
        jettyWebapp.setTempDirectory(new File(this._config.getTempFolder()));
        jettyWebapp.getSessionHandler().setHttpOnly(true);
        jettyWebapp.getSessionHandler().setSecureRequestOnly(true);
        jettyWebapp.getSessionHandler().setSessionCookie("SESSIONID" + port);
        jettyWebapp.setThrowUnavailableOnStartupException(true);
        jettyWebapp.setInitParameter("dirAllowed", "false");
        XmlWebApplicationContext springXmlWebApplicationContext = new XmlWebApplicationContext(this){

            protected void initBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
                xmlBeanDefinitionReader.setValidating(false);
            }
        };
        Properties httpAdapterProperties = new Properties();
        this.httpAdapterInfoDAO.ifExistsImportPropertiesFile(new File(this._config.getConfigFolder(), "httpadapter_" + port + ".properties"));
        HttpAdapterInfo httpAdapterInfo = this.httpAdapterInfoDAO.getHttpAdapterByPort(port);
        String propertyName = "httpadapter_" + port;
        if (httpAdapterInfo != null) {
            httpAdapterProperties = httpAdapterInfo.toProperties();
            LOG.info((Object)("HTTP Adapter properties '" + propertyName + "' loaded from DB."));
        }
        PropertiesPropertySource propertySource = new PropertiesPropertySource(propertyName, httpAdapterProperties);
        springXmlWebApplicationContext.getEnvironment().getPropertySources().addLast((PropertySource)propertySource);
        springXmlWebApplicationContext.setConfigLocations(new String[]{"file:" + webappPath + "/WEB-INF/context.xml"});
        springXmlWebApplicationContext.setParent(this._context);
        jettyWebapp.addEventListener((EventListener)new ContextLoaderListener((WebApplicationContext)springXmlWebApplicationContext));
        jettyWebapp.addEventListener((EventListener)new HttpSessionEventPublisher());
        Configurations classlist = Configurations.setServerDefault((org.eclipse.jetty.server.Server)server);
        classlist.add(new String[]{JettyWebXmlConfiguration.class.getName(), AnnotationConfiguration.class.getName()});
        ContextHandlerCollection handlerList = new ContextHandlerCollection(new ContextHandler[0]);
        handlerList.addHandler((Handler)jettyWebapp);
        server.setHandler(this.wrapWithSecurityHandler((Handler)handlerList));
        server.setErrorHandler((Request.Handler)new PontonErrorPageHandler());
        LOG.info((Object)"HTTP Adapter loaded.");
    }

    private void loadAdapterService(org.eclipse.jetty.server.Server server) {
        LOG.debug((Object)"Loading AdapterService");
        List handlers = server.getDescendants(ServletContextHandler.class);
        ServletContextHandler contextHandler = null;
        for (ServletContextHandler handler : handlers) {
            if (!this.getAdapterContext().equals(handler.getContextPath())) continue;
            contextHandler = handler;
            break;
        }
        if (contextHandler == null) {
            ContextHandlerCollection handlerCollection = (ContextHandlerCollection)server.getDescendant(ContextHandlerCollection.class);
            contextHandler = new ServletContextHandler(this.getAdapterContext());
            contextHandler.setErrorHandler((Request.Handler)new PontonErrorPageHandler());
            handlerCollection.setHandlers(new Handler[]{contextHandler});
            server.setHandler((Handler)handlerCollection);
        }
        contextHandler.addServlet(new ServletHolder((Servlet)this.adapterDispatcherServlet), "/AdapterService");
        LOG.info((Object)"AdapterService loaded");
    }

    private void loadListeners(org.eclipse.jetty.server.Server server) {
        List<String> activatedServices;
        LOG.debug((Object)"Loading Listeners");
        List handlers = server.getDescendants(ServletContextHandler.class);
        ServletContextHandler contextHandler = null;
        for (ServletContextHandler handler : handlers) {
            if (!this.getListenerContext().equals(handler.getContextPath())) continue;
            contextHandler = handler;
            break;
        }
        if (contextHandler == null) {
            ContextHandlerCollection handlerCollection = (ContextHandlerCollection)server.getDescendant(ContextHandlerCollection.class);
            contextHandler = new ServletContextHandler(this.getListenerContext());
            contextHandler.setErrorHandler((Request.Handler)new PontonErrorPageHandler());
            handlerCollection.setHandlers(new Handler[]{contextHandler});
            server.setHandler((Handler)handlerCollection);
        }
        if ((activatedServices = this._listenerManager.getActivatedServices()).isEmpty()) {
            LOG.fatal((Object)"No activated services found. Need at least one listener to receive messages via http(s). Check the installation or your messenger license.");
        } else {
            for (String serviceName : activatedServices) {
                LOG.trace((Object)("Adding Listener '" + serviceName + "'"));
                contextHandler.addServlet(new ServletHolder((Servlet)this.listenerDispatcherServlet), "/" + serviceName);
                LOG.info((Object)("ListenerService " + serviceName + " loaded"));
            }
        }
        LOG.info((Object)"Listeners loaded");
    }

    private void startMessenger() {
        for (ServiceLevel serviceLevel : ServiceLevel.SERVICE_LEVELS) {
            this.sendStartupEventAndWaitForResponse(serviceLevel);
        }
    }

    private void stopMessenger() {
        for (int i = ServiceLevel.SERVICE_LEVELS.size(); i > 0; --i) {
            this.sendShutdownEventAndWaitForResponse(ServiceLevel.SERVICE_LEVELS.get(i - 1));
        }
        LOG.info((Object)"clean shutdown completed.");
    }

    public void restartMessenger() {
        try {
            LOG.info((Object)"Going to restart Ponton X/P.");
            this._resultCode = ResultCode.RESTART;
            this.shutdown(true);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not perform restart.", (Throwable)e);
        }
    }

    private void sendStartupEventAndWaitForResponse(ServiceLevel serviceLevel) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Going to send the startup event to " + String.valueOf((Object)serviceLevel) + " service providers."));
        }
        try {
            this._context.publishEvent((ApplicationEvent)new StartupService(this, serviceLevel));
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not publish startup event.", (Throwable)e);
        }
        int stoppedServices = this.countStoppedServices(serviceLevel);
        while (stoppedServices > 0) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("There are still " + stoppedServices + " " + String.valueOf((Object)serviceLevel) + " service providers not fully started. Waiting ...."));
                }
                Thread.sleep(1000L);
                stoppedServices = this.countStoppedServices(serviceLevel);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void sendEnterMaintenanceModeEvent() {
        try {
            LOG.trace((Object)"Going to send EnterMaintenanceModeEvent to MaintenanceManager");
            this._context.publishEvent((ApplicationEvent)new EnterMaintenanceModeEvent(this, ServiceLevel.getServiceLevel(MaintenanceManager.class)));
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not send EnterMaintenanceModeEvent.", (Throwable)e);
        }
    }

    private void sendShutdownEventAndWaitForResponse(ServiceLevel serviceLevel) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Going to send the shutdown event to " + String.valueOf((Object)serviceLevel) + " service providers."));
        }
        try {
            this._context.publishEvent((ApplicationEvent)new ShutdownService(this, serviceLevel));
        }
        catch (Exception e) {
            LOG.error((Object)"Could not publish shutdown event.", (Throwable)e);
        }
        int startedServices = this.countStartedServices(serviceLevel);
        while (startedServices > 0) {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("There are still " + startedServices + " " + String.valueOf((Object)serviceLevel) + " service providers running. Waiting ...."));
                }
                Thread.sleep(1000L);
                startedServices = this.countStartedServices(serviceLevel);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private int countStartedServices(ServiceLevel serviceLevel) {
        int startedServices = 0;
        for (IServiceProvider service : this._serviceProviders.get((Object)serviceLevel).keySet()) {
            ServiceStatus status = this._serviceProviders.get((Object)serviceLevel).get(service);
            if (status == ServiceStatus.STARTED) {
                ++startedServices;
            }
            if (!this._messengerProperties.isDeveloperMode() || !LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Service '" + service.getServiceName() + "' is not stopped."));
        }
        return startedServices;
    }

    private int countStoppedServices(ServiceLevel serviceLevel) {
        int stoppedServices = 0;
        for (IServiceProvider service : this._serviceProviders.get((Object)serviceLevel).keySet()) {
            ServiceStatus status = this._serviceProviders.get((Object)serviceLevel).get(service);
            if (status != ServiceStatus.STOPPED) continue;
            ++stoppedServices;
            if (!this._messengerProperties.isDeveloperMode() || !LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Service '" + service.getServiceName() + "' is not started."));
        }
        return stoppedServices;
    }

    private void startServers() throws Exception {
        int adapterPort;
        boolean RESTexists = false;
        for (ServerSettings connector : this._config.getConnectors().values()) {
            boolean loadedREST = false;
            boolean loadedHTTPAdapter = false;
            org.eclipse.jetty.server.Server server = this.createJettyServer();
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            server.addBean((Object)mbContainer);
            int connectorPort = connector.getPort();
            if (this.isRESTconnector(connector) && !RESTexists && this.isPortUsed(connectorPort)) {
                LOG.error((Object)("Configured REST port " + connectorPort + " is already in use. Search for alternative port"));
                int nextPort = this.getNextFreePort(connectorPort + 10000);
                LOG.warn((Object)("Switched configured REST port from " + connectorPort + " to free port " + nextPort));
                System.out.println("ERROR: Configured REST port " + connectorPort + " is already in use. Using port " + nextPort);
                connectorPort = nextPort;
                this.sendEnterMaintenanceModeEvent();
            }
            ContextHandlerCollection handlerList = new ContextHandlerCollection(new ContextHandler[0]);
            server.setHandler(this.wrapWithSecurityHandler((Handler)handlerList));
            for (String serviceString : connector.getServices()) {
                try {
                    Services service = Services.valueOf(serviceString);
                    switch (service) {
                        case HTTP_ADAPTER: {
                            this.loadHTTPAdapter(server, connectorPort);
                            loadedHTTPAdapter = true;
                            break;
                        }
                        case REST: {
                            if (RESTexists) {
                                LOG.fatal((Object)"the GUI service must not exist on multiple connectors.");
                                throw new Exception("multiple GUI instances are not allowed");
                            }
                            this.loadREST(server, connectorPort);
                            loadedREST = true;
                            RESTexists = true;
                            break;
                        }
                        case LISTENERS: {
                            LOG.trace((Object)("Adding listeners to the connector " + connector.getAddress() + ":" + connectorPort));
                            this.loadListeners(server);
                            break;
                        }
                        case ADAPTER_SERVICE: {
                            this.loadAdapterService(server);
                            break;
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    LOG.warn((Object)("Unknown service '" + serviceString + "'"));
                }
            }
            try {
                String scheme;
                try {
                    server.start();
                }
                catch (Exception e) {
                    LOG.fatal((Object)("Unable to start the webserver. Reason: " + String.valueOf(e)));
                    throw e;
                }
                try {
                    ServerConnector socketListener = this.createSocketListener(connector, server);
                    socketListener.setPort(connectorPort);
                    server.addConnector((Connector)socketListener);
                    socketListener.start();
                    this._servers.add(server);
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to start the server connector '" + connector.getAddress() + ":" + connectorPort + "'. " + String.valueOf(e)));
                    this.sendEnterMaintenanceModeEvent();
                    System.out.println("ERROR: Unable to start the server connector '" + connector.getAddress() + ":" + connectorPort + "'. " + String.valueOf(e));
                }
                if (loadedHTTPAdapter) {
                    scheme = this.getScheme(connector);
                    this._httpAdapters.add(scheme + (connector.getAddress().equals("*") ? "localhost" : connector.getAddress()) + ":" + connectorPort);
                }
                if (!loadedREST) continue;
                scheme = this.getScheme(connector);
                this._restServers.add(scheme + (connector.getAddress().equals("*") ? "localhost" : connector.getAddress()) + ":" + connectorPort);
                if (connector.getPort() == connectorPort) continue;
                this.restPortSuffix = " (CONFIGURED PORT " + connector.getPort() + ")";
            }
            catch (Exception e) {
                this.shutdown(true);
                throw e;
            }
        }
        if (this._config.isAdapterInterfaceEnabled() && this.isPortUsed(adapterPort = this._config.getAdapterInterfacePort())) {
            LOG.error((Object)("Configured adapter interface port " + adapterPort + " is already in use. Search for alternative port"));
            int newPort = this.getNextFreePort(adapterPort + 10000);
            this._config.setAdapterInterfacePort(newPort);
            LOG.warn((Object)("Switched configured adapter interface port from " + adapterPort + " to free port " + newPort));
            this.sendEnterMaintenanceModeEvent();
        }
    }

    ServerConnector createSocketListener(ServerSettings connector, org.eclipse.jetty.server.Server server) throws Exception {
        ServerConnector socketListener;
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendXPoweredBy(false);
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig);
        if (connector.isSsl()) {
            SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
            secureRequestCustomizer.setSniRequired(false);
            secureRequestCustomizer.setSniHostCheck(false);
            httpConfig.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)secureRequestCustomizer);
            HTTP2ServerConnectionFactory http2ServerConnectionFactory = new HTTP2ServerConnectionFactory(httpsConfig);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol(httpConnectionFactory.getProtocol());
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(this.sslContextFactoryInitializer.configureSslContextFactory(connector.getServices().contains(Services.REST.toString())), alpn.getProtocol());
            socketListener = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, alpn, http2ServerConnectionFactory, httpConnectionFactory});
        } else {
            socketListener = new ServerConnector(server, new ConnectionFactory[]{httpConnectionFactory, new HTTP2CServerConnectionFactory(httpConfig)});
        }
        if (!connector.getAddress().equals("*")) {
            socketListener.setHost(connector.getAddress());
        }
        socketListener.setName(connector.getId());
        socketListener.setIdleTimeout((long)connector.getMaxIdleTimeMs());
        return socketListener;
    }

    org.eclipse.jetty.server.Server createJettyServer() {
        return new org.eclipse.jetty.server.Server();
    }

    private boolean isRESTconnector(ServerSettings connector) {
        return connector.getServices().contains(Services.REST.name());
    }

    private boolean isPortUsed(int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket(port);
        try {
            serverSocket.setReuseAddress(true);
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        serverSocket.close();
        return bl;
    }

    private int getNextFreePort(int port) {
        while (this.isPortUsed(++port)) {
        }
        return port;
    }

    private String getScheme(ServerSettings connector) {
        String scheme = connector.isSsl() ? "https://" : "http://";
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServers() {
        List<org.eclipse.jetty.server.Server> list = this._servers;
        synchronized (list) {
            for (org.eclipse.jetty.server.Server server : this._servers) {
                for (Connector connector : server.getConnectors()) {
                    try {
                        connector.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    server.removeConnector(connector);
                }
                try {
                    server.stop();
                }
                catch (Exception exception) {}
            }
            this._servers.clear();
        }
    }

    public boolean isStartupComplete() {
        return this.startupComplete;
    }

    public void init() throws Exception {
        LOG.info((Object)("Using PONTONXP_HOME '" + this._config.getXpHome().getAbsolutePath() + "'"));
        Path test = Files.createTempFile("xp-test", "dat", new FileAttribute[0]);
        LOG.info((Object)("Using TEMP          '" + String.valueOf(test.getParent()) + "'"));
        test.toFile().delete();
        this._restServers = new ArrayList<String>();
        this._httpAdapters = new ArrayList<String>();
        this._servers = new ArrayList<org.eclipse.jetty.server.Server>();
        this.startup();
        this._shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(this._shutdownHook);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ApplicationEvent applicationEvent = event;
        Objects.requireNonNull(applicationEvent);
        ApplicationEvent applicationEvent2 = applicationEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RegisterServiceProvider.class, StartupCompleted.class, StartupFailed.class, ShutdownCompleted.class}, (Object)applicationEvent2, n)) {
            case 0: {
                RegisterServiceProvider registerServiceProvider = (RegisterServiceProvider)applicationEvent2;
                IServiceProvider listener = (IServiceProvider)event.getSource();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Registering shutdown listener: " + listener.getServiceName()));
                }
                this._serviceProviders.get((Object)listener.getServiceLevel()).put(listener, ServiceStatus.STOPPED);
                break;
            }
            case 1: {
                StartupCompleted startupCompleted = (StartupCompleted)applicationEvent2;
                IServiceProvider listener = (IServiceProvider)event.getSource();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Completed startup: " + listener.getServiceName()));
                }
                this._serviceProviders.get((Object)listener.getServiceLevel()).put(listener, ServiceStatus.STARTED);
                break;
            }
            case 2: {
                StartupFailed startupFailedEvent = (StartupFailed)applicationEvent2;
                IServiceProvider listener = (IServiceProvider)event.getSource();
                if (LOG.isTraceEnabled()) {
                    LOG.warn((Object)("Startup of: " + listener.getServiceName() + " failed." + (String)(!startupFailedEvent.getError().isEmpty() ? " Reason: " + startupFailedEvent.getError() : DEFAULT_REST_WEB_CONTEXT) + (String)(startupFailedEvent.getCause() != null ? " Exception: " + startupFailedEvent.getCause().toString() : DEFAULT_REST_WEB_CONTEXT)));
                }
                this._serviceProviders.get((Object)listener.getServiceLevel()).put(listener, ServiceStatus.FAILURE);
                break;
            }
            case 3: {
                ShutdownCompleted shutdownCompleted = (ShutdownCompleted)applicationEvent2;
                IServiceProvider listener = (IServiceProvider)event.getSource();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Completed shutdown: " + listener.getServiceName()));
                }
                this._serviceProviders.get((Object)listener.getServiceLevel()).put(listener, ServiceStatus.STOPPED);
                break;
            }
        }
    }

    private String getGUIContext() {
        return this._messengerProperties.getProperty(PROPERTY_WEB_CONTEXT_GUI, DEFAULT_WEB_CONTEXT);
    }

    private String getListenerContext() {
        return this._messengerProperties.getProperty(PROPERTY_WEB_CONTEXT_LISTENER, DEFAULT_WEB_CONTEXT);
    }

    private String getAdapterContext() {
        return this._messengerProperties.getProperty(PROPERTY_WEB_CONTEXT_ADAPTER, DEFAULT_WEB_CONTEXT);
    }

    private String getRestContext() {
        return this._messengerProperties.getProperty(PROPERTY_WEB_CONTEXT_REST, DEFAULT_REST_WEB_CONTEXT);
    }

    public Object getActiveServer() {
        return this._activeServer;
    }

    public String getName() {
        return "XP-Server";
    }

    public Integer getResultCode() {
        return Objects.requireNonNullElse(this._resultCode, ResultCode.SHUTDOWN).getResultCode();
    }

    private Handler wrapWithSecurityHandler(Handler h) {
        ConstraintMapping traceMapping = new ConstraintMapping();
        traceMapping.setConstraint(Constraint.FORBIDDEN);
        traceMapping.setMethod("TRACE");
        traceMapping.setPathSpec("/");
        ConstraintMapping optionsMapping = new ConstraintMapping();
        optionsMapping.setConstraint(Constraint.FORBIDDEN);
        optionsMapping.setMethod("OPTIONS");
        optionsMapping.setPathSpec("/");
        ConstraintSecurityHandler handler = new ConstraintSecurityHandler();
        handler.addConstraintMapping(traceMapping);
        handler.setHandler(h);
        return handler;
    }

    protected class ShutdownHook
    extends Thread {
        protected ShutdownHook() {
        }

        @Override
        public void run() {
            try {
                Server.this.shutdown(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

