/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.xmlsig;

import de.pontonconsulting.xmlpipe.security.xmlsig.DocumentReference;
import de.pontonconsulting.xmlpipe.security.xmlsig.DocumentResolver;
import de.pontonconsulting.xmlpipe.security.xmlsig.SignException;
import de.pontonconsulting.xmlpipe.security.xmlsig.VerifyException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApacheSigner {
    private static Log _log = LogFactory.getFactory().getInstance("Messenger.XmlSignature");
    private static final String EBXML_TRANSFORM = "not (ancestor-or-self::node() [@soapenv:actor=\"urn:oasis:names:tc:ebxml-msg:actor:nextMSH\"] | ancestor-or-self::node() [@soapenv:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"] )";
    private static final String EBXML_SIGNATURE_XPATH = "/*[namespace-uri()=\"http://schemas.xmlsoap.org/soap/envelope/\" and local-name()=\"Envelope\"]/*[namespace-uri()=\"http://schemas.xmlsoap.org/soap/envelope/\"and local-name()=\"Header\"]/*[namespace-uri()=\"http://www.w3.org/2000/09/xmldsig#\" and local-name()=\"Signature\"]";
    protected static final String DSIG_URI = "http://www.w3.org/2000/09/xmldsig#";
    protected Document _envelope = null;
    protected ArrayList<DocumentReference> _documents = new ArrayList();
    protected XMLSignature _signature = null;
    private Element _signatureElement;

    public boolean verify(PublicKey publicKey) throws VerifyException {
        block26: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"start verifying...");
            }
            if (this._envelope == null) {
                throw new VerifyException(29001, "Envelope element not set!");
            }
            NodeList nodeList = this._envelope.getElementsByTagNameNS(DSIG_URI, "Signature");
            this._signatureElement = null;
            try {
                this._signatureElement = (Element)nodeList.item(0);
            }
            catch (Exception e) {
                try {
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    this._signatureElement = (Element)xPath.evaluate(EBXML_SIGNATURE_XPATH, this._envelope, XPathConstants.NODE);
                }
                catch (Exception e1) {
                    throw new VerifyException(29002, "No <ds:Signature> found by using XPATH!");
                }
                if (this._signatureElement != null) break block26;
                throw new VerifyException(29002, "No <ds:Signature> found!");
            }
        }
        String baseUri = DSIG_URI;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"got the signature element");
        }
        try {
            this._signature = new XMLSignature(this._signatureElement, DSIG_URI);
        }
        catch (XMLSecurityException e) {
            throw new VerifyException(29003, "Cannot create XMLSignature object: " + e.getMessage());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"created signature object");
        }
        DocumentReference[] doc_array = new DocumentReference[this._documents.size()];
        for (int i = 0; i < doc_array.length; ++i) {
            doc_array[i] = this._documents.get(i);
        }
        DocumentResolver resolver = new DocumentResolver(doc_array);
        this._signature.addResourceResolver((ResourceResolverSpi)resolver);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"created document resolver");
        }
        KeyInfo keyInfo = this._signature.getKeyInfo();
        Certificate[] certs = null;
        if (keyInfo != null && publicKey == null) {
            try {
                if (keyInfo.containsX509Data()) {
                    X509Certificate certificate;
                    int certPathLen = keyInfo.lengthX509Data();
                    if (certPathLen > 0) {
                        certs = new Certificate[certPathLen];
                        for (int i = 0; i < certPathLen; ++i) {
                            try {
                                certs[i] = keyInfo.itemX509Data(i).itemCertificate(0).getX509Certificate();
                                continue;
                            }
                            catch (XMLSecurityException e) {
                                throw new VerifyException(29005, "Cannot get keys from <ds:KeyInfo>: " + e.getMessage());
                            }
                        }
                    }
                    if ((certificate = keyInfo.getX509Certificate()) != null) {
                        publicKey = certificate.getPublicKey();
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)"got public key and certificate chain from xml signature");
                        }
                    }
                }
            }
            catch (KeyResolverException e) {
                throw new VerifyException(29006, "Cannot extract key info: " + e.getMessage());
            }
        }
        if (publicKey == null) {
            throw new VerifyException(29007, "No Public Key supplied, and none found in XML Signature !");
        }
        boolean ret = false;
        try {
            ret = this._signature.checkSignatureValue((Key)publicKey);
        }
        catch (XMLSignatureException e) {
            throw new VerifyException(29008, "Cannot verify: " + e.getMessage());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("checked signature value, result: " + ret));
        }
        return ret;
    }

    public void setEnvelope(Document doc, String algo) throws SignException {
        this._envelope = doc;
        try {
            this._signature = new XMLSignature(this._envelope, DSIG_URI, DSIG_URI + algo);
        }
        catch (XMLSecurityException e) {
            _log.error((Object)"error while preparing signature", (Throwable)e);
            throw new SignException(28001, "Cannot create XMLSignature object: " + e.getMessage());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("setEnvelope, using algorithm: " + algo));
        }
    }

    public void setEnvelope(Document doc) throws SignException {
        this.setEnvelope(doc, "rsa-sha1");
    }

    public void addDocument(String uri, InputStream inputStream, String contentType) {
        DocumentReference docDetail = new DocumentReference(uri, contentType, inputStream);
        this._documents.add(docDetail);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("addDocument URI: " + uri + ", contentType: " + contentType));
        }
    }

    public void sign(PrivateKey privateKey, Certificate[] certificateChain) throws SignException {
        int i;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"start signing...");
        }
        if (this._envelope == null) {
            throw new SignException(28002, "Envelope element not set!");
        }
        DocumentReference[] doc_array = new DocumentReference[this._documents.size()];
        for (int i2 = 0; i2 < doc_array.length; ++i2) {
            doc_array[i2] = this._documents.get(i2);
        }
        DocumentResolver resolver = new DocumentResolver(doc_array);
        this._signature.addResourceResolver((ResourceResolverSpi)resolver);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"created DocumentResolver");
        }
        Transforms transforms = new Transforms(this._envelope);
        try {
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            XPathContainer xpathC = new XPathContainer(this._envelope);
            xpathC.setXPath(EBXML_TRANSFORM);
            transforms.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xpathC.getElement());
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        }
        catch (TransformationException e) {
            _log.error((Object)"transformation failed", (Throwable)e);
            throw new SignException(28003, "Transformation problem: " + e.getMessage());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"created Transform");
        }
        try {
            this._signature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        }
        catch (XMLSignatureException e) {
            _log.error((Object)"error while adding ebxml enveloper", (Throwable)e);
            throw new SignException(28004, "Cannot add ebxml envelope: " + e.getMessage());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"added main document (envelope)");
        }
        for (i = 0; i < this._documents.size(); ++i) {
            DocumentReference dd = this._documents.get(i);
            try {
                this._signature.addDocument(dd.getUri());
                continue;
            }
            catch (XMLSignatureException e) {
                throw new SignException(28005, new String[]{dd.getUri()}, "Cannot add document " + dd.getUri() + ": " + e.getMessage());
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("added " + this._documents.size() + " attachment documents"));
        }
        if (certificateChain == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No Certificates will be send with Message.");
            }
        } else {
            for (i = 0; i < certificateChain.length; ++i) {
                try {
                    this._signature.addKeyInfo((X509Certificate)certificateChain[i]);
                    continue;
                }
                catch (XMLSecurityException e) {
                    throw new SignException(28006, "Cannot add key info: " + e.getMessage());
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Added the Certificate Chain to signature (" + certificateChain.length + " Certificates)"));
            }
        }
        try {
            this._signature.sign((Key)privateKey);
        }
        catch (XMLSignatureException e) {
            _log.error((Object)"could not sign", (Throwable)e);
            throw new SignException(28007, "Cannot sign: " + e.getMessage());
        }
        catch (Throwable e) {
            _log.error((Object)"unexpected error while signing", e);
            throw new SignException(28007, "Cannot sign: " + e.getMessage());
        }
        for (i = 0; i < doc_array.length; ++i) {
            try {
                doc_array[i].getStream().close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"signed");
        }
    }

    public Certificate extractSenderCertificate() throws VerifyException {
        X509Certificate certificate = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"start extracting...");
        }
        if (this._envelope == null) {
            throw new VerifyException(29001, "Envelope element not set!");
        }
        NodeList nodeList = this._envelope.getElementsByTagNameNS(DSIG_URI, "Signature");
        if (nodeList.getLength() == 0) {
            throw new VerifyException(29002, "No <ds:Signature> found!");
        }
        Element signatureElement = (Element)nodeList.item(0);
        String baseUri = DSIG_URI;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"got the signature element");
        }
        try {
            this._signature = new XMLSignature(signatureElement, DSIG_URI);
        }
        catch (XMLSecurityException e) {
            throw new VerifyException(29003, "Cannot create XMLSignature object: " + e.getMessage());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"created signature object");
        }
        KeyInfo keyInfo = this._signature.getKeyInfo();
        try {
            if (keyInfo.containsX509Data() && (certificate = keyInfo.getX509Certificate()) != null && _log.isDebugEnabled()) {
                _log.debug((Object)"got certificate from xml signature");
            }
        }
        catch (KeyResolverException e) {
            throw new VerifyException(29009, "Cannot extract key info: " + e.getMessage());
        }
        return certificate;
    }

    public Element getElement() {
        if (this._signature != null) {
            return this._signature.getElement();
        }
        return null;
    }
}

