/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.smime;

import de.pontonconsulting.xmlpipe.security.CertificateInfo;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEHandler;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEUnknownSignCertificateExeption;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEValidationException;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEVerifyResult;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimePart;
import java.io.File;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.mail.smime.SMIMESignedParser;

public class SMIMEVerifier
extends SMIMEHandler {
    private final CertificateUtility certificateUtility;

    public SMIMEVerifier(CertificateUtility certificateUtility) {
        this.certificateUtility = certificateUtility;
        this.initiate();
    }

    public MimeBodyPart verifySignature(MimePart message, X509Certificate senderCertificate) throws SMIMEValidationException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        certificates.add(senderCertificate);
        SMIMEVerifyResult result = this.verifySignature(message, certificates);
        return result.getBodyPart();
    }

    public SMIMEVerifyResult verifySignature(MimePart message, Collection<X509Certificate> senderCertificates) throws SMIMEValidationException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("bcContent", ".mime");
            SMIMESignedParser signed = CryptoUtil.createSMIMESignedParser(message, tempFile);
            SignerInformationStore signers = signed.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            boolean signatureOk = false;
            ArrayList<CertificateInfo> unknowCertificates = new ArrayList<CertificateInfo>();
            X509Certificate usedCertificate = null;
            String signAlgorithm = null;
            block6: while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                SignerId signerId = signer.getSID();
                CertificateInfo certificateInfo = new CertificateInfo(signerId.getIssuer(), signerId.getSerialNumber());
                for (X509Certificate senderCertificate : senderCertificates) {
                    BigInteger senderSerialNumber = senderCertificate.getSerialNumber();
                    X500Principal issuerX500Principal = senderCertificate.getIssuerX500Principal();
                    X500Name certInfoIssuer = certificateInfo.getIssuer();
                    boolean issuerEquals = CryptoUtil.isPrincipalsEqual(certInfoIssuer, issuerX500Principal);
                    if (senderSerialNumber.equals(certificateInfo.getSerial()) && issuerEquals) {
                        SignerInformationVerifier verifier = CryptoUtil.createVerifier(senderCertificate);
                        signatureOk = signer.verify(verifier);
                        if (!signatureOk) {
                            throw new SMIMEValidationException(26005, "Signature is not valid.");
                        }
                        signAlgorithm = CryptoUtil.getSignatureAlgorithm(signer);
                        usedCertificate = senderCertificate;
                        continue block6;
                    }
                    unknowCertificates.add(certificateInfo);
                }
            }
            if (!signatureOk) {
                throw new SMIMEUnknownSignCertificateExeption(26007, this.certificateUtility.getSignatureUnknownErrorTextFor(unknowCertificates), unknowCertificates);
            }
            MimeBodyPart part = signed.getContent();
            signed.close();
            SMIMEVerifyResult result = new SMIMEVerifyResult();
            result.setBodyPart(part);
            result.setSenderCertificate(usedCertificate);
            result.setSignatureAlgorithm(signAlgorithm);
            SMIMEVerifyResult sMIMEVerifyResult = result;
            return sMIMEVerifyResult;
        }
        catch (SMIMEValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SMIMEValidationException(26004, "Problem while processing MIME content:" + e.toString());
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }
}

