/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.smime;

import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEHandler;
import jakarta.mail.internet.MimeBodyPart;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;

public class SMIMEEncrypter
extends SMIMEHandler {
    public SMIMEEncrypter() {
        this.initiate();
    }

    public MimeBodyPart createEncryptedMimePart(MimeBodyPart mimePart, String algorithm, Certificate receiverCert, String contentTransferEncoding) throws GeneralSecurityException, SMIMEException, CMSException {
        String symmetricAlgorithm = CryptoUtil.extractSymmetricAlgorithm(algorithm);
        String asymmetricAlgorithm = CryptoUtil.extractAsymmetricAlgorithm(algorithm);
        CryptoUtil.SMIMEEnvelopedGeneratorTupel smimeGen = CryptoUtil.createSMIMEGenerator((X509Certificate)receiverCert, asymmetricAlgorithm, symmetricAlgorithm);
        ASN1ObjectIdentifier identifier = CryptoUtil.getASN1ObjectIdentifier(symmetricAlgorithm);
        if (identifier == null) {
            throw new NoSuchAlgorithmException("Not supported encryption algorithm: " + algorithm + "'.");
        }
        return smimeGen.generate(identifier, mimePart);
    }
}

