/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.smime;

import de.pontonconsulting.xmlpipe.security.CertificateInfo;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import de.pontonconsulting.xmlpipe.security.CryptoUtil;
import de.pontonconsulting.xmlpipe.security.smime.SMIMEHandler;
import de.pontonconsulting.xmlpipe.security.util.SignCertInfo;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.KeyAgreeRecipientId;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.mail.smime.SMIMEEnvelopedParser;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.util.FileBackedMimeBodyPart;

public class SMIMEDecrypter
extends SMIMEHandler {
    private final CertificateUtility certificateUtility;

    public SMIMEDecrypter(CertificateUtility certificateUtility) {
        this.certificateUtility = certificateUtility;
        this.initiate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMIMEDecryptResult decryptMimeMessage(List<SignCertInfo> signCertInfos, MimeBodyPart mime) throws SMIMEException, CMSException, IOException, MessagingException, NoSuchAlgorithmException {
        SMIMEEnvelopedParser smime = null;
        try {
            smime = new SMIMEEnvelopedParser(mime);
            SMIMEDecryptResult sMIMEDecryptResult = this.decryptMimeMessage(signCertInfos, smime);
            return sMIMEDecryptResult;
        }
        finally {
            if (smime != null) {
                try {
                    smime.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public SMIMEDecryptResult decryptMimeMessage(List<SignCertInfo> signCertInfos, SMIMEEnvelopedParser smime) throws SMIMEException, CMSException, IOException, NoSuchAlgorithmException {
        FileBackedMimeBodyPart decryptedContent;
        PrivateKey privateKeyToBeUsed = null;
        RecipientInformation recipient = null;
        X509Certificate usedCertificate = null;
        AlgorithmIdentifier keyEncryptionAlgorithmIdentifier = null;
        RecipientInformationStore recipients = smime.getRecipientInfos();
        KeyTransRecipientId recId = null;
        X500Name issuer = null;
        for (SignCertInfo signCertInfo : signCertInfos) {
            X509Certificate receiverCert = null;
            PrivateKey privateKey = null;
            if (signCertInfo.getCertificateChain() != null && signCertInfo.getCertificateChain().length > 0) {
                receiverCert = signCertInfo.getCertificateChain()[0];
            }
            privateKey = signCertInfo.getPrivateKey();
            if (receiverCert == null || privateKey == null) continue;
            issuer = X500Name.getInstance((Object)receiverCert.getIssuerX500Principal().getEncoded());
            if ("RSA".equals(receiverCert.getPublicKey().getAlgorithm())) {
                recId = new KeyTransRecipientId(issuer, receiverCert.getSerialNumber());
            } else if ("EC".equals(receiverCert.getPublicKey().getAlgorithm())) {
                recId = new KeyAgreeRecipientId(issuer, receiverCert.getSerialNumber());
            } else {
                throw new NoSuchAlgorithmException("Receiver certificate is neither RSA nor EC");
            }
            if ((recipient = recipients.get((RecipientId)recId)) == null) continue;
            keyEncryptionAlgorithmIdentifier = recipient.getKeyEncryptionAlgorithm();
            privateKeyToBeUsed = privateKey;
            usedCertificate = receiverCert;
            break;
        }
        if (privateKeyToBeUsed == null) {
            ArrayList<CertificateInfo> unknowCertificates = new ArrayList<CertificateInfo>();
            if (recId instanceof KeyTransRecipientId) {
                Iterator iterator = recipients.getRecipients().iterator();
                while (iterator.hasNext()) {
                    KeyTransRecipientId usedKeyInfo = (KeyTransRecipientId)((RecipientInformation)iterator.next()).getRID();
                    unknowCertificates.add(new CertificateInfo(usedKeyInfo.getIssuer(), usedKeyInfo.getSerialNumber()));
                }
            } else if (recId instanceof KeyAgreeRecipientId) {
                X500Name finalIssuer = issuer;
                recipients.getRecipients().forEach(rec -> {
                    KeyAgreeRecipientId usedKeyInfo = (KeyAgreeRecipientId)rec.getRID();
                    unknowCertificates.add(new CertificateInfo(finalIssuer, usedKeyInfo.getSerialNumber()));
                });
            }
            throw new SMIMEException(this.certificateUtility.getDecryptionUnknownErrorTextFor(unknowCertificates));
        }
        if (privateKeyToBeUsed instanceof RSAPrivateKey) {
            privateKeyRecipient = CryptoUtil.createTransEnvelopedRecipient(privateKeyToBeUsed);
            decryptedContent = SMIMEUtil.toMimeBodyPart((CMSTypedStream)recipient.getContentStream((Recipient)privateKeyRecipient));
        } else if (privateKeyToBeUsed instanceof ECPrivateKey) {
            privateKeyRecipient = CryptoUtil.createKeyAgreeEnvelopedRecipient(privateKeyToBeUsed);
            CMSTypedStream contentStream = recipient.getContentStream((Recipient)privateKeyRecipient);
            decryptedContent = SMIMEUtil.toMimeBodyPart((CMSTypedStream)contentStream);
        } else {
            throw new NoSuchAlgorithmException("Private key is neither RSA nor EC");
        }
        String usedAlgorithm = CryptoUtil.getUsedEncryptionAlgorithm(keyEncryptionAlgorithmIdentifier, smime.getContentEncryptionAlgorithm());
        return new SMIMEDecryptResult(this, (MimeBodyPart)decryptedContent, usedCertificate, usedAlgorithm);
    }

    public class SMIMEDecryptResult {
        private final MimeBodyPart _decryptedContent;
        private final X509Certificate _usedCertificate;
        private final String _usedAlgorithm;

        SMIMEDecryptResult(SMIMEDecrypter this$0, MimeBodyPart decryptedContent, X509Certificate usedCertificate, String usedAlgorithm) {
            this._decryptedContent = decryptedContent;
            this._usedCertificate = usedCertificate;
            this._usedAlgorithm = usedAlgorithm;
        }

        public MimeBodyPart getDecryptedContent() {
            return this._decryptedContent;
        }

        public X509Certificate getUsedCertificate() {
            return this._usedCertificate;
        }

        public String getUsedAlgorithm() {
            return this._usedAlgorithm;
        }
    }
}

