/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.codec;

import de.pontonconsulting.xmlpipe.adapter.util.StringUtils;
import de.pontonconsulting.xmlpipe.security.codec.PushbackString;

public class JavaScriptDecoder {
    private JavaScriptDecoder() {
    }

    public static Character decodeCharacter(PushbackString input) {
        Character second;
        block32: {
            input.mark();
            Character first = input.next();
            if (first == null) {
                input.reset();
                return null;
            }
            if (first.charValue() != '\\') {
                input.reset();
                return null;
            }
            second = input.next();
            if (second == null) {
                input.reset();
                return null;
            }
            if (second.charValue() == 'b') {
                return Character.valueOf('\b');
            }
            if (second.charValue() == 't') {
                return Character.valueOf('\t');
            }
            if (second.charValue() == 'n') {
                return Character.valueOf('\n');
            }
            if (second.charValue() == 'v') {
                return Character.valueOf('\u000b');
            }
            if (second.charValue() == 'f') {
                return Character.valueOf('\f');
            }
            if (second.charValue() == 'r') {
                return Character.valueOf('\r');
            }
            if (second.charValue() == '\"') {
                return Character.valueOf('\"');
            }
            if (second.charValue() == '\'') {
                return Character.valueOf('\'');
            }
            if (second.charValue() == '\\') {
                return Character.valueOf('\\');
            }
            if (Character.toLowerCase(second.charValue()) == 'x') {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < 2; ++i) {
                    Character c = input.nextHex();
                    if (c == null) {
                        input.reset();
                        return null;
                    }
                    sb.append(c);
                }
                try {
                    i = Integer.parseInt(sb.toString(), 16);
                    if (Character.isValidCodePoint(i)) {
                        return Character.valueOf((char)i);
                    }
                    break block32;
                }
                catch (NumberFormatException e) {
                    input.reset();
                    return null;
                }
            }
            if (Character.toLowerCase(second.charValue()) == 'u') {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < 4; ++i) {
                    Character c = input.nextHex();
                    if (c == null) {
                        input.reset();
                        return null;
                    }
                    sb.append(c);
                }
                try {
                    i = Integer.parseInt(sb.toString(), 16);
                    if (Character.isValidCodePoint(i)) {
                        return Character.valueOf((char)i);
                    }
                    break block32;
                }
                catch (NumberFormatException e) {
                    input.reset();
                    return null;
                }
            }
            if (PushbackString.isOctalDigit(second)) {
                StringBuilder sb = new StringBuilder();
                sb.append(second);
                Character c2 = input.next();
                if (!PushbackString.isOctalDigit(c2)) {
                    input.pushback(c2);
                } else {
                    sb.append(c2);
                    Character c3 = input.next();
                    if (!PushbackString.isOctalDigit(c3)) {
                        input.pushback(c3);
                    } else {
                        sb.append(c3);
                    }
                }
                try {
                    int i = Integer.parseInt(sb.toString(), 8);
                    if (Character.isValidCodePoint(i)) {
                        return Character.valueOf((char)i);
                    }
                }
                catch (NumberFormatException e) {
                    input.reset();
                    return null;
                }
            }
        }
        return second;
    }

    public static String decode(String input) {
        StringBuilder sb = new StringBuilder();
        PushbackString pbs = new PushbackString(input);
        while (pbs.hasNext()) {
            Character c = JavaScriptDecoder.decodeCharacter(pbs);
            if (c != null) {
                sb.append(c);
                continue;
            }
            sb.append(pbs.next());
        }
        return sb.toString();
    }

    public static String canonicalize(String javascript) {
        if (StringUtils.isBlank((CharSequence)javascript)) {
            return javascript;
        }
        String working = javascript;
        boolean clean = false;
        while (!clean) {
            clean = true;
            String old = working;
            if (old.equals(working = JavaScriptDecoder.decode(working))) continue;
            clean = false;
        }
        return working;
    }
}

