/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.certificate;

import de.pontonconsulting.xmlpipe.security.certificate.ICertificateFilter;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.List;
import java.util.stream.Collectors;

public class PublicKeyCertificateFilter
implements ICertificateFilter {
    @Override
    public List<X509Certificate> doFilter(X509Certificate currentCertificate, List<X509Certificate> certificates) {
        return certificates.stream().filter(certificate -> {
            if (currentCertificate.getPublicKey() instanceof RSAKey && certificate.getPublicKey() instanceof RSAKey) {
                return true;
            }
            return currentCertificate.getPublicKey() instanceof ECKey && certificate.getPublicKey() instanceof ECKey;
        }).collect(Collectors.toList());
    }
}

