/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.certificate;

import de.pontonconsulting.xmlpipe.messenger.ReferenceDateTask;
import de.pontonconsulting.xmlpipe.security.certificate.ICertificateFilter;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CertificateValidityFilter
implements ICertificateFilter {
    private final ReferenceDateTask referenceDateTask;

    public CertificateValidityFilter(ReferenceDateTask referenceDateTask) {
        this.referenceDateTask = referenceDateTask;
    }

    @Override
    public List<X509Certificate> doFilter(X509Certificate currentCertificate, List<X509Certificate> certificates) {
        Date now = this.referenceDateTask.getReferenceDate();
        Date minValidDate = new Date(now.getTime() + TimeUnit.DAYS.toMillis(30L));
        return certificates.stream().filter(cert -> {
            try {
                cert.checkValidity(now);
                return cert.getNotAfter().after(minValidDate);
            }
            catch (Exception e) {
                return false;
            }
        }).toList();
    }
}

