/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.bsi;

import de.pontonconsulting.xmlpipe.TempFileCreator;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.Body;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.CallbackIndicatorType;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.CertType;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.CertificateSequenceType;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.Envelope;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.Header;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.ObjectFactory;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.RequestCertificateReq;
import de.pontonconsulting.xmlpipe.jaxb.smartmeterpki.RequestCertificateRes;
import de.pontonconsulting.xmlpipe.messenger.transport.HttpProvider;
import de.pontonconsulting.xmlpipe.messenger.transport.ProviderResponse;
import de.pontonconsulting.xmlpipe.messenger.transport.TransportException;
import de.pontonconsulting.xmlpipe.security.bsi.SmartMeterPkiException;
import de.pontonconsulting.xmlpipe.security.bsi.SmartMeterPkiServer;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.output.XmlStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SmartMeterPkiService {
    private static final Logger LOG = LogManager.getLogger((String)"Messenger.SmartMeterPkiService");
    private static final String CONFIG_PREFIX = "de.bund.bsi.smartmeterpki.subca.";
    private final MessengerConfig messengerConfig;
    private final JAXBContext jaxbContext;
    private final ObjectFactory objectFactory;
    private final MessageFactory messageFactory;
    private final HttpProvider httpProvider;
    private final TempFileCreator tempFileCreator;
    private final SortedMap<String, SmartMeterPkiServer> smartMeterPkiServers;

    public SmartMeterPkiService(MessengerConfig messengerConfig, JAXBContext jaxbContext, ObjectFactory objectFactory, MessageFactory messageFactory, HttpProvider httpProvider, TempFileCreator tempFileCreator) {
        this.messengerConfig = messengerConfig;
        this.jaxbContext = jaxbContext;
        this.objectFactory = objectFactory;
        this.messageFactory = messageFactory;
        this.httpProvider = httpProvider;
        this.tempFileCreator = tempFileCreator;
        this.smartMeterPkiServers = this.readAllServerConfigurations();
    }

    public SortedSet<String> getAllServerNames() {
        return new TreeSet<String>(this.smartMeterPkiServers.keySet());
    }

    public Optional<SmartMeterPkiServer> getSmartMeterPkiServer(String name) {
        return Optional.ofNullable((SmartMeterPkiServer)this.smartMeterPkiServers.get(name));
    }

    private SortedMap<String, SmartMeterPkiServer> readAllServerConfigurations() {
        TreeMap<String, SmartMeterPkiServer> servers = new TreeMap<String, SmartMeterPkiServer>();
        int index = 0;
        do {
            this.fetchServerConfiguration(++index).ifPresent(server -> servers.put(server.getName(), (SmartMeterPkiServer)server));
        } while (servers.size() == index);
        return servers;
    }

    private Optional<SmartMeterPkiServer> fetchServerConfiguration(int index) {
        String name = this.messengerConfig.getProperty(CONFIG_PREFIX + index + ".name");
        String url = this.messengerConfig.getProperty(CONFIG_PREFIX + index + ".url");
        if (name != null && url != null) {
            try {
                SmartMeterPkiServer server = new SmartMeterPkiServer(name, new URI(url));
                LOG.trace("SmartMeterPkiServer {} added", (Object)name);
                return Optional.of(server);
            }
            catch (URISyntaxException e) {
                LOG.warn("SmartMeterPkiServer {} entry has invalid URI. {}", (Object)name, (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> requestCertificate(SmartMeterPkiServer smartMeterPkiServer, byte[] bdewCertificateRequest, X509Certificate[] certificateChain, PrivateKey privateKey) throws SmartMeterPkiException {
        RequestCertificateReq requestCertificateReq = this.objectFactory.createRequestCertificateReq();
        requestCertificateReq.setCallbackIndicator(CallbackIndicatorType.CALLBACK_NOT_POSSIBLE);
        requestCertificateReq.setCertReq(bdewCertificateRequest);
        Header header = this.objectFactory.createHeader();
        header.getAny().add(this.objectFactory.createCertType(CertType.EMT));
        Body body = this.objectFactory.createBody();
        body.getAny().add(requestCertificateReq);
        Envelope envelope = this.objectFactory.createEnvelope();
        envelope.setHeader(header);
        envelope.setBody(body);
        try {
            SOAPMessage soapMessage = this.convertToSOAP(envelope, "RequestCertificate");
            soapMessage.setProperty("javax.xml.soap.character-set-encoding", (Object)"UTF-8");
            soapMessage.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
            HashMap<String, String> headers = this.convertHeaders(soapMessage.getMimeHeaders());
            File content = this.tempFileCreator.createTempFile("smart-meter-pki", ".soap");
            try {
                try (OutputStream outputStream = Files.newOutputStream(content.toPath(), new OpenOption[0]);){
                    soapMessage.writeTo(outputStream);
                }
                ProviderResponse providerResponse = this.httpProvider.sendData(content, Files.size(content.toPath()), "text/xml; charset=\"utf-8\"", headers, smartMeterPkiServer.getUri(), certificateChain, privateKey, null, null, 60);
                byte[] responseMessage = providerResponse.getResponseMessage();
                if (providerResponse.isFailed()) {
                    throw new SmartMeterPkiException("Error occurred while sending certificate request: " + new String(responseMessage, StandardCharsets.UTF_8));
                }
                JAXBElement<Envelope> envelopeJAXBElement = this.unmarshal(responseMessage);
                Envelope responseEnvelope = (Envelope)envelopeJAXBElement.getValue();
                List bodyElements = responseEnvelope.getBody().getAny();
                if (bodyElements.isEmpty()) throw new SmartMeterPkiException("Could not parse the response: " + new String(responseMessage, StandardCharsets.UTF_8));
                Optional fistElement = bodyElements.stream().findFirst();
                if (!fistElement.isPresent()) throw new SmartMeterPkiException("Could not parse the response: " + new String(responseMessage, StandardCharsets.UTF_8));
                Object e = fistElement.get();
                if (!(e instanceof RequestCertificateRes)) throw new SmartMeterPkiException("Could not parse the response: " + new String(responseMessage, StandardCharsets.UTF_8));
                RequestCertificateRes requestCertificateRes = (RequestCertificateRes)e;
                RequestCertificateRes.RequestCertificateResReturnCode returnCode = requestCertificateRes.getReturnCode();
                switch (returnCode) {
                    case OK_CERT_AVAILABLE: {
                        CertificateSequenceType certificateSeq = requestCertificateRes.getCertificateSeq();
                        List<byte[]> list = List.copyOf(certificateSeq.getCertificate());
                        return list;
                    }
                }
                String returnCodeMessage = requestCertificateRes.getReturnCodeMessage();
                throw new SmartMeterPkiException("SubCA refuses certificate request with return code '%s' and message '%s'.".formatted(returnCode, returnCodeMessage));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SmartMeterPkiException("Could not send certificate request to Sub-CA.", e);
            }
            finally {
                try {
                    this.tempFileCreator.deleteFile(content);
                }
                catch (IOException e) {
                    LOG.warn("Could not delete temporary file {}", (Object)content.getAbsolutePath(), (Object)e);
                }
            }
        }
        catch (TransportException | JAXBException | IOException | SOAPException e) {
            throw new SmartMeterPkiException("Could not send certificate request to Sub-CA.", e);
        }
    }

    private HashMap<String, String> convertHeaders(MimeHeaders headers) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        headers.getAllHeaders().forEachRemaining(mimeHeader -> hashMap.put(mimeHeader.getName(), mimeHeader.getValue()));
        return hashMap;
    }

    private SOAPMessage convertToSOAP(Envelope envelope, String soapAction) throws SOAPException, IOException, JAXBException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        this.marshal(envelope, byteStream);
        byte[] contentArray = byteStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contentArray);
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.setHeader("Content-Type", "text/xml; charset=\"utf-8\"");
        mimeHeaders.setHeader("SOAPAction", soapAction);
        return this.messageFactory.createMessage(mimeHeaders, (InputStream)inputStream);
    }

    private void marshal(Envelope envelope, OutputStream outputStream) throws JAXBException, IOException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        marshaller.marshal((Object)envelope, (Writer)((XmlStreamWriter.Builder)XmlStreamWriter.builder().setOutputStream(outputStream)).get());
    }

    private JAXBElement<Envelope> unmarshal(byte[] message) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        return unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(message)), Envelope.class);
    }
}

