/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security.acegi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.pontonconsulting.xmlpipe.adapter.AdapterRegistry;
import de.pontonconsulting.xmlpipe.config.IMessengerProperties;
import de.pontonconsulting.xmlpipe.config.IServerConfigBean;
import de.pontonconsulting.xmlpipe.cpa.Agreements;
import de.pontonconsulting.xmlpipe.cpp.Profiles;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.Message;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessageDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.MessengerConfigDAO;
import de.pontonconsulting.xmlpipe.messenger.database.tables.PartnerProfileDAO;
import de.pontonconsulting.xmlpipe.security.acegi.ClientRole;
import de.pontonconsulting.xmlpipe.security.acegi.PontonUserDetailsServiceImpl;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ClientRoleService {
    private static String PROPERTY_CLIENT_ROLES_FILE = "client.roles.path";
    private ApplicationContext applicationContext;
    private final Path rolesFile;
    private final ObjectMapper objectMapper;
    private final Set<ClientRole> clientRoles = new TreeSet<ClientRole>(Comparator.comparing(ClientRole::getDescription));
    private final Set<Runnable> onClientRolesChange = new HashSet<Runnable>();
    private final Agreements agreements;
    private final MessageDAO messageDAO;
    private final Profiles profiles;
    private final AdapterRegistry adapterRegistry;
    private final PontonUserDetailsServiceImpl pontonUserDetailsService;
    private final MessengerConfigDAO messengerConfigDAO;
    private final PartnerProfileDAO partnerProfileDAO;

    public ClientRoleService(IServerConfigBean serverConfig, IMessengerProperties messengerProperties, ObjectMapper objectMapper, Agreements agreements, MessageDAO messageDAO, Profiles profiles, AdapterRegistry adapterRegistry, PontonUserDetailsServiceImpl pontonUserDetailsService, MessengerConfigDAO messengerConfigDAO, PartnerProfileDAO partnerProfileDAO) throws IOException {
        this.agreements = agreements;
        this.messageDAO = messageDAO;
        this.profiles = profiles;
        this.adapterRegistry = adapterRegistry;
        this.pontonUserDetailsService = pontonUserDetailsService;
        this.messengerConfigDAO = messengerConfigDAO;
        this.partnerProfileDAO = partnerProfileDAO;
        this.rolesFile = Path.of(messengerProperties.getProperty(PROPERTY_CLIENT_ROLES_FILE, Path.of(serverConfig.getConfigFolder().toString(), "clientRoles.json").toString()), new String[0]);
        this.objectMapper = objectMapper;
    }

    @PostConstruct
    protected void postConstruct() throws IOException {
        this.load();
        this.profiles.addPartnerDeleteEventListener(this::onPartnerRemoved);
        this.adapterRegistry.addAdapterDeleteEventListener(this::onAdapterRemoved);
        this.pontonUserDetailsService.addUserDeleteEventListener(this::onUserRemoved);
    }

    @PreDestroy
    protected void preDestroy() throws IOException {
        this.profiles.removePartnerDeleteEventListener(this::onPartnerRemoved);
        this.adapterRegistry.removeAdapterDeleteEventListener(this::onAdapterRemoved);
        this.pontonUserDetailsService.removeUserDeleteEventListener(this::onUserRemoved);
    }

    private void load() throws IOException {
        this.clientRoles.clear();
        if (Files.exists(this.rolesFile, new LinkOption[0]) && !this.messengerConfigDAO.doesMessengerConfigExist("clientRoles.json")) {
            this.messengerConfigDAO.storeMessengerConfig(Files.readAllBytes(this.rolesFile), "clientRoles.json", "SYSTEM");
            Files.delete(this.rolesFile);
        } else if (!this.messengerConfigDAO.doesMessengerConfigExist("clientRoles.json")) {
            this.messengerConfigDAO.storeMessengerConfig("[]".getBytes(), "clientRoles.json", "SYSTEM");
        }
        this.clientRoles.addAll((Collection)this.objectMapper.readValue(this.messengerConfigDAO.loadMessengerConfig("clientRoles.json").getData(), (TypeReference)new TypeReference<List<ClientRole>>(this){}));
    }

    private void save(String username) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            this.objectMapper.writeValue((OutputStream)byteArrayOutputStream, new ArrayList<ClientRole>(this.clientRoles));
            this.messengerConfigDAO.storeMessengerConfig(byteArrayOutputStream.toByteArray(), "clientRoles.json", username);
        }
        this.onClientRolesChange.forEach(Runnable::run);
    }

    public synchronized Set<ClientRole> getClientRoles() {
        return Collections.unmodifiableSet(this.clientRoles);
    }

    public synchronized void saveRoles(List<ClientRole> clientRoles, String username) throws IOException {
        this.clientRoles.clear();
        this.clientRoles.addAll(clientRoles);
        this.save(username);
    }

    public void addOnClientRoleChange(Runnable runnable) {
        this.onClientRolesChange.add(runnable);
    }

    public boolean verifyAgreementAccess(String agreementId, String username) {
        return this.verifyPartnerAccess(this.agreements.getLocalPartnerOfAgreement(agreementId), username);
    }

    public boolean verifyMessageAccess(Long databaseId, String username) {
        try {
            Message message = this.messageDAO.getMessage(databaseId);
            if (1 == message.getInbound()) {
                return this.verifyPartnerAccess(message.getReceiverId(), username) && this.verifyAdapterAccess(message.getAdapterId(), username);
            }
            return this.verifyPartnerAccess(message.getSenderId(), username) && this.verifyAdapterAccess(message.getAdapterId(), username);
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean verifyMessageAccess(String databaseId, String username) {
        try {
            return this.verifyMessageAccess(Long.parseLong(databaseId), username);
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public List<String> getWhitelistedAdapters(String username) {
        return this.clientRoles.stream().filter(clientRole -> clientRole.getUserIds().stream().anyMatch(user -> user.equals(username))).flatMap(clientRole -> clientRole.getAdapterIds().stream()).toList();
    }

    public List<String> getWhitelistedPartners(String username) {
        return this.clientRoles.stream().filter(clientRole -> clientRole.getUserIds().stream().anyMatch(user -> user.equals(username))).flatMap(clientRole -> clientRole.getPartnerIds().stream()).toList();
    }

    public boolean verifyPartnerAccess(String partnerId, String username) {
        if (partnerId == null) {
            return true;
        }
        if (this.partnerProfileDAO.isPartnerRemote(partnerId)) {
            return true;
        }
        List<ClientRole> roles = this.clientRoles.stream().filter(clientRole -> clientRole.getUserIds().stream().anyMatch(userId -> userId.equals(username))).toList();
        if (roles.isEmpty()) {
            return true;
        }
        return roles.stream().anyMatch(clientRole -> clientRole.getPartnerIds().stream().anyMatch(partner -> partner.equals(partnerId)));
    }

    public boolean verifyAdapterAccess(String adapterId, String username) {
        List<ClientRole> roles = this.clientRoles.stream().filter(clientRole -> clientRole.getUserIds().stream().anyMatch(userId -> userId.equals(username))).toList();
        if (roles.isEmpty()) {
            return true;
        }
        return roles.stream().anyMatch(clientRole -> clientRole.getAdapterIds().stream().anyMatch(partner -> partner.equals(adapterId)));
    }

    private synchronized void onPartnerRemoved(String partnerId) {
        this.clientRoles.forEach(clientRole -> clientRole.getPartnerIds().remove(partnerId));
        try {
            this.save("SYSTEM");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void onAdapterRemoved(String adapterId) {
    }

    private synchronized void onUserRemoved(String userId) {
        this.clientRoles.forEach(clientRole -> clientRole.getUserIds().remove(userId));
        try {
            this.save("SYSTEM");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

