/*
 * Decompiled with CFR 0.152.
 */
package de.pontonconsulting.xmlpipe.security;

import de.pontonconsulting.xmlpipe.config.KeystoreBean;
import de.pontonconsulting.xmlpipe.config.MessengerConfig;
import de.pontonconsulting.xmlpipe.messenger.database.hibernate.KnownServerCertificate;
import de.pontonconsulting.xmlpipe.messenger.database.tables.KnownServerCertificateDAO;
import de.pontonconsulting.xmlpipe.security.CertificateUtility;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerCertificateTrustManager
implements X509TrustManager {
    private static final Logger LOG = LogManager.getLogger((String)("Messenger." + ServerCertificateTrustManager.class.getName()));
    private final MessengerConfig messengerConfig;
    private final CertificateUtility certificateUtility;
    private final KeystoreBean keystoreBean;
    private final KnownServerCertificateDAO knownServerCertificateDAO;

    public ServerCertificateTrustManager(MessengerConfig messengerConfig, CertificateUtility certificateUtility, KeystoreBean keystoreBean, KnownServerCertificateDAO knownServerCertificateDAO) throws IOException {
        this.messengerConfig = messengerConfig;
        this.certificateUtility = certificateUtility;
        this.keystoreBean = keystoreBean;
        this.knownServerCertificateDAO = knownServerCertificateDAO;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        KnownServerCertificate knownServerCertificate;
        try {
            if (!this.messengerConfig.isSSLCertificateCheck()) {
                return;
            }
        }
        catch (JAXBException e) {
            LOG.warn("Could not get SSLCertificateCheck flag.", (Throwable)e);
            return;
        }
        X509Certificate certificate = chain[0];
        this.keystoreBean.getKeystore().checkCertificate(certificate);
        String certificateId = this.getCertificateId(certificate);
        try {
            knownServerCertificate = this.knownServerCertificateDAO.loadKnownServerCertificate(certificateId);
        }
        catch (Exception e) {
            LOG.warn("Could not load KnownServerCertificate '{}' from DB: {}", (Object)certificateId, (Object)e.toString());
            return;
        }
        if (knownServerCertificate == null) {
            try {
                this.knownServerCertificateDAO.storeNewKnownServerCertificate(certificateId, this.certificateUtility.getBase64(certificate));
            }
            catch (Exception e) {
                LOG.error("Could not save certificate '{}' for future revocation checks: {}", (Object)certificateId, (Object)e.toString());
            }
        } else {
            if (knownServerCertificate.isDisabled()) {
                throw new CertificateException("Certificate " + certificateId + " was not successfully checked within the last 3 days");
            }
            if (knownServerCertificate.isRevoked()) {
                throw new CertificateException("Certificate " + certificateId + " has been revoked with reason: " + String.valueOf((Object)knownServerCertificate.getCrlReason()));
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    private String getCertificateId(X509Certificate certificate) {
        return certificate.getIssuerX500Principal().getName() + String.valueOf(certificate.getSerialNumber());
    }
}

